/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.buffer;

import com.thelastcheck.commons.buffer.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.io.HexDump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayDumpFormatter {
    private static final String CVS_ID = "$Date: 2010/11/15 17:42:05 $ $Revision: 1.3 $";
    private static Logger logDump;
    private ByteArray byteArray = null;
    private OutputStream out = null;
    private static final char NEWLINE = '\n';

    private ByteArrayDumpFormatter() {
    }

    public ByteArrayDumpFormatter(ByteArray byteArray) {
        this.byteArray = byteArray;
    }

    public ByteArrayDumpFormatter(ByteArray byteArray, OutputStream out) {
        this.byteArray = byteArray;
        this.out = out;
    }

    public void dump() {
        ByteArrayDumpFormatter.dumpByteArray("", this.byteArray, this.out);
    }

    public void dump(String title) {
        ByteArrayDumpFormatter.dumpByteArray(title, this.byteArray, this.out);
    }

    public void dump(String title, OutputStream out) {
        ByteArrayDumpFormatter.dumpByteArray(title, this.byteArray, out);
    }

    public static void dumpByteArray(String title, ByteArray byteArray) {
        if (logDump.isDebugEnabled()) {
            ByteArrayDumpFormatter.dumpByteArray(title, byteArray, null);
        }
    }

    public static void dumpByteArray(String title, ByteArray byteArray, OutputStream out) {
        if (logDump.isDebugEnabled()) {
            byte[] bytes = null;
            if (byteArray.hasArray()) {
                ByteArray.UnderlyingArray array = byteArray.getArray();
                if (array.offset == 0 && array.length == array.value.length) {
                    bytes = array.value;
                }
            }
            if (bytes == null) {
                bytes = byteArray.getBytes();
            }
            ByteArrayDumpFormatter.dumpByteArray(title, bytes, out);
        }
    }

    public static void dumpByteArray(String title, byte[] byteArray) {
        if (logDump.isDebugEnabled()) {
            ByteArrayDumpFormatter.dumpByteArray(title, byteArray, null);
        }
    }

    private static void dumpByteArray(String title, byte[] byteArray, OutputStream out) {
        int estimatedSizeOfHexdump = byteArray.length * 75;
        ByteArrayOutputStream dumpOut = new ByteArrayOutputStream(estimatedSizeOfHexdump);
        try {
            HexDump.dump((byte[])byteArray, (long)0L, (OutputStream)dumpOut, (int)0);
            if (out == null) {
                logDump.debug(title + '\n' + dumpOut.toString());
            } else {
                out.write(new Date().toString().getBytes());
                out.write(10);
                out.write(title.getBytes());
                out.write(10);
                out.write(dumpOut.toByteArray());
                out.write(10);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logDump.error("ArrayIndexOutOfBoundsException", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logDump.error("IllegalArgumentException", (Throwable)e);
        }
        catch (IOException e) {
            logDump.error("IOException", (Throwable)e);
        }
    }

    static {
        String className = ByteArrayDumpFormatter.class.getName();
        LoggerFactory.getLogger((String)"version").info(className + " | " + CVS_ID);
        logDump = LoggerFactory.getLogger((String)"DumpByteArray");
    }
}

