package com.tenqube.visual_third.parser.loader;

import android.content.Context;

import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.manager.CurrencyManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.repository.VisualRepository;

import java.util.ArrayList;

import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParsingRule;
import tenqube.parser.model.Transaction;

import static com.tenqube.visual_third.Constants.RULE_VERSION;
import static com.tenqube.visual_third.manager.PrefManager.PARSING_RULE_VERSION;

class BaseLoader {

    final Context mContext;
    ParserService parserService;
    VisualApi api;
    PrefManager prefManager;
    VisualRepository repository;
    private CurrencyManager currencyManager;


    BaseLoader(Context context) {
        this.mContext = context;

        this.parserService = ParserService.getInstance(context);
        parserService.setDebugMode(true);
        this.api = VisualApi.getInstance(context);
        this.repository = VisualRepository.getInstance(context);
        this.prefManager = PrefManager.getInstance(context);

        this.currencyManager = CurrencyManager.getInstance(context);
    }

    void syncParsingRule() {
        ParsingRule parsingRule = api.syncParsingRule(prefManager.loadIntValue(PARSING_RULE_VERSION, RULE_VERSION));

        if(parsingRule != null) {
            parserService.syncParsingRule(parsingRule);
            prefManager.saveIntValue(PARSING_RULE_VERSION, parsingRule.ruleVersion);
        }

    }

    void setCurrency(ArrayList<Transaction> transactions) {
        for(tenqube.parser.model.Transaction parsedTran : transactions) {
            // 환율 계산
            parsedTran.spentMoney = currencyManager.calculateSpentMoney(parsedTran.spentMoney, parsedTran.currency);
        }
    }



}
