/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Validator;
import java.util.Calendar;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualServiceImpl
implements VisualService {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    private PrefManager prefManager;
    private AppCompatActivity activity;
    private VisualApi api;
    private ParserService parserService;
    private boolean isDoingSignup;
    private boolean isDoingStartVisual;

    public VisualServiceImpl(@NonNull AppCompatActivity activity, String apiKey, String qualifier) throws ParameterException {
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            throw new ParameterException("apiKey is null");
        }
        if (TextUtils.isEmpty((CharSequence)qualifier) || !"dev".equals(qualifier) && !"prod".equals(qualifier)) {
            throw new ParameterException("check qualifier value (dev, prod)");
        }
        this.activity = activity;
        VisualRepository.getInstance((Context)activity);
        this.prefManager = PrefManager.getInstance((Context)activity);
        this.prefManager.saveStringValue("TENQUBE_API_KEY", apiKey);
        this.prefManager.saveStringValue("TENQUBE_QUALIFIER", qualifier);
        this.api = VisualApi.getInstance((Context)activity);
        this.parserService = ParserService.getInstance((Context)activity);
    }

    @Override
    public void signUp(@NonNull String custId, final @NonNull OnResultListener onResultListener) throws ParameterException {
        LogUtil.LOGI((String)TAG, (String)"\uac00\uc785", (boolean)ParserService.mIsDebug);
        if (this.isDoingSignup) {
            return;
        }
        this.isDoingSignup = true;
        final SignUpRequest signUpRequest = new SignUpRequest(custId);
        Validator.notNull(onResultListener);
        if (!TextUtils.isEmpty((CharSequence)this.prefManager.loadStringValue("TENQUBE_UID", ""))) {
            onResultListener.onResult(2, "already joined");
            this.isDoingSignup = false;
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                SignUpResponse response = VisualServiceImpl.this.api.signUp(signUpRequest);
                if (response == null) {
                    onResultListener.onResult(1, "network error");
                } else {
                    VisualServiceImpl.this.prefManager.saveStringValue("TENQUBE_SEARCH_URL", response.getResults().getSearch().getUrl());
                    VisualServiceImpl.this.prefManager.saveStringValue("TENQUBE_SEARCH_API_KEY", response.getResults().getSearch().getApiKey());
                    VisualServiceImpl.this.prefManager.saveStringValue("TENQUBE_UID", response.getResults().getAuthorization().getSdk());
                    VisualServiceImpl.this.prefManager.saveLongValue("TENQUBE_SIGN_UP_TIME", Calendar.getInstance().getTimeInMillis());
                    if (response.getResults().getWeb() != null) {
                        VisualServiceImpl.this.prefManager.saveStringValue("TENQUBE_WEB_URL", response.getResults().getWeb().getUrl());
                    }
                    onResultListener.onResult(0, "success");
                }
                VisualServiceImpl.this.isDoingSignup = false;
            }
        }).start();
    }

    @Override
    public void startVisual(@NonNull String custId, final @NonNull OnResultListener resultListener) throws ParameterException, SecurityException {
        LogUtil.LOGI((String)TAG, (String)"\uc6f9 \uac00\uacc4\ubd80 \ud638\ucd9c", (boolean)ParserService.mIsDebug);
        if (this.isDoingStartVisual) {
            return;
        }
        this.isDoingStartVisual = true;
        Validator.notNull(resultListener);
        this.checkSMSPermission();
        this.signUp(custId, new OnResultListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(int signUpResult, String msg) {
                switch (signUpResult) {
                    case 0: 
                    case 2: {
                        try {
                            VisualWebActivity.startActivity((Context)VisualServiceImpl.this.activity, "");
                            break;
                        }
                        catch (AuthException e) {
                            resultListener.onResult(1, e.toString());
                            return;
                        }
                        finally {
                            VisualServiceImpl.this.isDoingStartVisual = false;
                        }
                    }
                }
                resultListener.onResult(signUpResult, msg);
                VisualServiceImpl.this.isDoingStartVisual = false;
            }
        });
    }

    @Override
    public boolean isActiveTranPopup() {
        return this.prefManager.isEnabled("TENQUBE_TRAN_POPUP", true);
    }

    @Override
    public void setTranPopup(boolean isActive) {
        this.prefManager.saveBoolean("TENQUBE_TRAN_POPUP", isActive);
    }

    private void checkSMSPermission() throws SecurityException {
        if (!this.prefManager.isEnabled("TENQUBE_BULK_EXECUTED", false) && ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.READ_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_MMS") != 0) {
            throw new SecurityException("Please grant permissions (Manifest.permission.READ_SMS, Manifest.permission.RECEIVE_SMS, Manifest.permission.RECEIVE_MMS)");
        }
    }

    @Override
    public void setDebugMode(boolean isDebug) {
        LogUtil.LOGI((String)TAG, (String)"setDebugMode", (boolean)ParserService.mIsDebug);
        if (this.isActive() && this.parserService != null) {
            this.parserService.setDebugMode(isDebug);
        }
    }

    @Override
    public void initSDK() {
        LogUtil.LOGI((String)TAG, (String)"initSDK", (boolean)ParserService.mIsDebug);
        if (this.isActive() && this.parserService != null) {
            this.parserService.initDb();
        }
    }

    private boolean isActive() {
        return this.activity != null && !this.activity.isFinishing();
    }
}

