package com.tenqube.visual_third.parser.loader;

import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.content.LocalBroadcastManager;

import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.FusedLocationManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.ui.TransactionPopupActivity;
import com.tenqube.visual_third.util.Mapper;

import java.util.ArrayList;

import tenqube.parser.model.ParserResult;
import tenqube.parser.model.ResultCode;
import tenqube.parser.model.SMS;
import tenqube.parser.model.Transaction;

import static com.tenqube.visual_third.Constants.SAMSUNG_PAY;
import static com.tenqube.visual_third.util.Utils.shouldParsing;
import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

/**
 * SMS or MMS or NOTI 수신시 실행
 *
 */
public class OneLoader extends BaseLoader {

    public static final String ACTION_TRANSACTION_RECEIVED = "tenqube.intent.action.ACTION_TRANSACTION_RECEIVED";
    private static final String TAG = OneLoader.class.getSimpleName();
    private static OneLoader mInstance = null;
    private final FusedLocationManager fusedLocationManager;
    private int mServerCnt = 0;


    private OneLoader(Context context) {
        super(context);
        this.fusedLocationManager = FusedLocationManager.getInstance(context);

    }

    /**
     * ParserResult의 코드에따라서 파싱된내역 서버전송, 파싱룰 동기화 안잡힌거 전송으로 분기
     *
     * @param sms 문자 데이터
     */
    public synchronized void doParsing(final SMS sms) {

        new Thread(new Runnable() {
            @Override
            public void run() {

                LOGI(TAG, "doParsing" + sms.toString(), mIsDebug);


                // 파싱
                ParserResult parserResult = parserService.parse(sms);

                // 실패하고 삼성페이인경우 title 로 파싱
                if (parserResult.resultCode != ResultCode.SEND_TO_SERVER &&
                        SAMSUNG_PAY.equals(sms.sender)) {

                    sms.fullSms = sms.title;
                    parserResult = parserService.parse(sms);

                }

                // 파싱 결과에 따른 분기
                LOGI(TAG, "parserResult" + (parserResult.resultCode) + ResultCode.stringValueOf(parserResult.resultCode), mIsDebug);

                switch (parserResult.resultCode) {
                    case ResultCode.NEED_TO_SYNC_PARSING_RULE:
                        syncParsingRule();
                        break;

                    case ResultCode.NEED_TO_SYNC_PARSING_RULE_NO_SENDER:
                        if (shouldParsing(sms.fullSms)) syncParsingRuleAndNoSender();
                        break;

                    case ResultCode.NEED_TO_SEND_TO_SERVER:
                        break;

                    case ResultCode.SEND_TO_SERVER:
                        fusedLocationManager.buildGoogleApiClient();
                        fusedLocationManager.onStart();

                        parsedSMS(parserResult.transactions);
                        break;

                }

                fusedLocationManager.onStop();

            }
        }).start();


    }

    private void syncParsingRuleAndNoSender() {
        mServerCnt++;
        if (mServerCnt == 5) {
            mServerCnt = 0;
            syncParsingRule();
        }
    }

    public static OneLoader getInstance(Context context) {
        synchronized (OneLoader.class) {
            if (mInstance == null) {
                mInstance = new OneLoader(context.getApplicationContext());
            }
        }
        return mInstance;
    }

    /**
     * 파싱된 경우
     * 결과값 저장 및 파싱된 내역 구글 캘린더 알림 노출 등 기존 로직 처리
     *
     * @param transactions 파싱된 내역
     */
    private void parsedSMS(ArrayList<Transaction> transactions) {

        try {

            Transaction currentTran = getCurrentTransaction(transactions);

            if (currentTran == null) return;

            // 위치정보 추가
            addLocationInfo(currentTran);

            // 환율
            setCurrency(transactions);

            // 내역 합치기
            repository.mergeTransactions(transactions);

            // 기존 일괄 적용 확인 currentTran
            com.tenqube.visual_third.entity.Transaction applyAllTran = repository.loadApplyAllTran(currentTran.keyword);

            SearchCompanyResponse searchCompanyResponse;

            if (applyAllTran != null) { // 서버 검색 요청 없이 사용자 내역으로 생성
                ArrayList<SearchCompanyResponse.TranCompany> results = new ArrayList<>();
                SearchCompanyResponse.Company company = new SearchCompanyResponse.Company(applyAllTran.getCompanyId(), applyAllTran.getFranchise(), "");
                SearchCompanyResponse.Category category = new SearchCompanyResponse.Category(applyAllTran.getCategoryCode() + "");
                SearchCompanyResponse.Keyword keyword = new SearchCompanyResponse.Keyword(applyAllTran.getKeyword(), applyAllTran.getSearchKeyword());
                SearchCompanyResponse.TranCompany tranCompany = new SearchCompanyResponse.TranCompany("" + applyAllTran.getIdentifier(), applyAllTran.getClassCode(), company, category, keyword);
                results.add(tranCompany);
                searchCompanyResponse = new SearchCompanyResponse(results);

            } else { // 서버 검색요청
                searchCompanyResponse = api.searchCompany(new SearchCompanyRequest(Mapper.toSearchTransaction(transactions)));
            }

            if (searchCompanyResponse != null) {
                repository.updateTransactions(searchCompanyResponse);

                // 팝업 띄움. current Tran && 중복 아닌경
                if (currentTran.isDuplicate == 0)
                    checkCurrentTranInfo(searchCompanyResponse, currentTran);
            }

            api.syncTransactions(null);

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private Transaction getCurrentTransaction(ArrayList<Transaction> transactions) {

        for (Transaction transaction : transactions) {

            if (transaction.isCurrentTran) {
                return transaction;
            }
        }
        return null;
    }

    private void addLocationInfo(Transaction currentTran) {
        Location location = fusedLocationManager.getLocation();
        if (location != null) {
            currentTran.spentLatitude = location.getLatitude();
            currentTran.spentLongitude = location.getLongitude();
        } else {
            currentTran.spentLatitude = -1;
            currentTran.spentLongitude = -1;
        }
    }

    /**
     * 파싱 결과 팝업
     */
    private void checkCurrentTranInfo(final SearchCompanyResponse searchCompanyResponse, Transaction currentTran) {

        for (SearchCompanyResponse.TranCompany company : searchCompanyResponse.getResults()) {
            if (company.getIdentifier().equals(currentTran.identifier)) {
                startTranPopup(currentTran, company);
                return;
            }
        }

        startTranPopup(currentTran, null);

    }

    private void startTranPopup(final Transaction currentTran, final SearchCompanyResponse.TranCompany company) {

        new Handler(mContext.getMainLooper()).post(new Runnable() {
            public void run() {
                try {

                    LocalBroadcastManager.getInstance(mContext).sendBroadcast(new Intent(ACTION_TRANSACTION_RECEIVED));

                    TransactionPopupInfo transactionPopupInfo = new TransactionPopupInfo(currentTran,
                            company);
                    TransactionPopupActivity.startActivity(mContext, transactionPopupInfo);

                } catch (ParameterException e) {
                    e.printStackTrace();
                } catch (AuthException e) {
                    e.printStackTrace();
                }

            }
        });

    }
}