package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.gt;
import static com.tenqube.visual_third.util.Validator.isStr;
import static com.tenqube.visual_third.util.Validator.lt;

public class TransactionRequest extends Request implements Serializable {

    private int year;
    private int month;
    private int before;
    private String callbackJS;

    public TransactionRequest(int year, int month, int before, String callbackJS) {
        this.year = year;
        this.month = month;
        this.before = before;
        this.callbackJS = callbackJS;
    }

    public int getYear() {
        return year;
    }

    public int getMonth() {
        return month;
    }

    public int getBefore() {
        return before;
    }

    public String getCallbackJS() {
        return callbackJS;
    }

    @Override
    public void checkParams() throws ParameterException {
        gt(year, 2010);
        lt(month, 12);
        gt(month, 1);
        lt(before, 12);
        isStr(callbackJS, 20);
    }
}
