package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Card;

import java.util.ArrayList;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class CardDao {

    private final Db db;

    public CardDao(Db db) {
        this.db = db;
    }

    public void loadAll() {
        LOGI("LOADALL", "card loadAll", mIsDebug);
        String query = QueryGenerator.card();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        LOGI("LOADALL", ReaderContract.CardTable.populateModel(c).toString(), mIsDebug);
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }
    }


    public ArrayList<Card> loadCards() {
        String query = QueryGenerator.card();
        ArrayList<Card> results = new ArrayList<>();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        results.add(ReaderContract.CardTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }

    public int getCardId(String cardName, int cardType, int cardSubType) {
        String query = QueryGenerator.cardId(cardName, cardType, cardSubType);
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        return c.getInt(c.getColumnIndex(ReaderContract.CardTable.COLUMN_CARD_ID));
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }

        return -1;
    }

    public int insert(String cardName, int cardType, int cardSubType) {

        ContentValues values = new ContentValues();
        values.put(ReaderContract.CardTable.COLUMN_CARD_NAME, cardName);
        values.put(ReaderContract.CardTable.COLUMN_CARD_TYPE, cardType);
        values.put(ReaderContract.CardTable.COLUMN_CARD_SUB_TYPE, cardSubType);

        values.put(ReaderContract.CardTable.COLUMN_CHANGE_NAME, cardName);
        values.put(ReaderContract.CardTable.COLUMN_CHANGE_TYPE, cardType);
        values.put(ReaderContract.CardTable.COLUMN_CHANGE_SUB_TYPE, cardSubType);

        return (int) db.insert(ReaderContract.CardTable.TABLE_NAME, values);
    }

}
