package com.tenqube.visual_third.analysis;

import android.util.SparseArray;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.model.analysis.AggregationValue;
import com.tenqube.visual_third.model.analysis.Result;
import com.tenqube.visual_third.model.analysis.Transaction;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

import static com.tenqube.visual_third.Constants.ALCOHOL_TYPE;
import static com.tenqube.visual_third.Constants.ALCOHOL_TYPE_IMAGE;
import static com.tenqube.visual_third.Constants.CNT;
import static com.tenqube.visual_third.Constants.COFFEE_TYPE_COUNTRY;
import static com.tenqube.visual_third.Constants.COFFEE_TYPE_COUNTRY_AMOUNT;
import static com.tenqube.visual_third.Constants.MCODE.ALCOHOL;
import static com.tenqube.visual_third.Constants.SUM;
import static com.tenqube.visual_third.analysis.AnalysisHelper.desc;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getAggregate;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getAggregatedTranIds;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getCoffeeCountry;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getFuncAmount;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getMidImage;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getPercentValue;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getTranIds;
import static com.tenqube.visual_third.util.Utils.getDiffDay;
import static com.tenqube.visual_third.util.Utils.getRand;

public class FunctionMap {

    /**
     * keys
     */
    public static final int month_0 = 1;
    public static final int month_0_sum = 2;
    public static final int month_0_cnt = 3;
    public static final int month_0_avg = 4;
    public static final int month_0_sum_credit = 5;
    public static final int month_0_sum_check = 6;
    public static final int month_0_sum_cash = 7;


    public static final int month_1 = 28;
    public static final int month_1_sum = 29;
    public static final int month_1_cnt = 30;

    public static final int month_1_avg = 31;
    public static final int month_1_sum_same_period = 32;
    public static final int month_1_sum_credit = 33;
    public static final int month_1_sum_check = 34;
    public static final int month_1_sum_cash = 35;
    public static final int month_1_category_first_name = 36;
    public static final int month_1_category_first_sum = 37;
    public static final int month_1_category_first_percent = 38;
    public static final int month_1_category_second_name = 39;
    public static final int month_1_category_second_sum = 40;
    public static final int month_1_category_second_percent = 41;
    public static final int month_1_category_third_name = 42;
    public static final int month_1_category_third_sum = 43;
    public static final int month_1_category_third_percent = 44;

    public static final int month_1_mid_alcohol_sum = 54;
    public static final int month_1_mid_coffee_sum = 55;
    public static final int month_1_mid_mart_sum = 56;
    public static final int month_1_mid_convenience_sum = 57;
    public static final int month_1_mid_category_first_name = 59;
    public static final int month_1_mid_category_first_sum = 60;
    public static final int month_1_mid_category_first_percent = 61;
    public static final int month_1_mid_category_second_name = 62;
    public static final int month_1_mid_category_second_sum = 63;

    public static final int month_1_mid_category_second_percent = 64;
    public static final int month_1_mid_category_third_name = 65;
    public static final int month_1_mid_category_third_sum = 66;
    public static final int month_1_mid_category_third_percent = 67;
    public static final int month_1_mid_alcohol_cnt = 68;

    public static final int month_2 = 69;
    public static final int month_2_sum = 70;
    public static final int month_2_cnt = 71;
    public static final int month_2_avg = 72;


    public static final int month_2_mid_alcohol_sum = 95;
    public static final int month_2_mid_coffee_sum = 96;
    public static final int month_2_mid_mart_sum = 97;
    public static final int month_2_mid_convenience_sum = 98;

    public static final int month_3 = 99;
    public static final int month_3_sum = 100;
    public static final int month_3_cnt = 101;
    public static final int month_3_avg = 102;

    public static final int month_3_mid_alcohol_sum = 125;
    public static final int month_3_mid_coffee_sum = 126;
    public static final int month_3_mid_mart_sum = 127;
    public static final int month_3_mid_convenience_sum = 128;

    public static final int three_month_mid_alcohol_sum = 129;
    public static final int three_month_mid_coffee_sum = 130;

    public static final int three_month_mid_mart_sum = 131;
    public static final int three_month_mid_convenience_sum = 132;
    public static final int three_month_mid_coffee_cnt = 133;
    public static final int three_month_mid_coffee_country = 134;
    public static final int three_month_mid_taxi_sum = 135;
    public static final int three_month_mid_taxi_am_sum = 136;
    public static final int three_month_book_sum = 137;


    public static final int last_hospital_date = 164;
    public static final int last_movie_date = 165;
    public static final int last_movie_keyword = 166;
    public static final int three_month_movie_cnt = 167;
    public static final int last_nail_date = 168;
    public static final int last_nail_keyword = 169;
    public static final int three_month_nail_cnt = 170;
    public static final int last_hair_date = 171;
    public static final int last_hair_keyword = 172;
    public static final int three_month_hair_avg_cnt = 173;
    public static final int yesterday_sum = 174;

    public static final int yesterday_max_keyword = 175;
    public static final int yesterday_max_spent_money = 176;
    public static final int three_month_mid_coffee_am_sum = 177;
    public static final int three_month_mid_coffee_country_value = 178;
    public static final int last_hair_diff_day = 179;
    public static final int last_nail_diff_day = 180;
    public static final int last_hospital_diff_day = 181;
    public static final int last_movie_diff_day = 182;

    public static final int three_month_large_food_cnt = 186;
    public static final int three_month_mid_fastfood_cnt = 188;
    public static final int three_month_mid_fastfood_percent = 189;
    public static final int three_month_first_mid_fastfood_keyword = 190;
    public static final int three_month_first_mid_fastfood_cnt = 191;
    public static final int three_month_second_mid_fastfood_keyword = 192;
    public static final int three_month_second_mid_fastfood_cnt = 193;
    public static final int three_month_third_mid_fastfood_keyword = 194;
    public static final int three_month_third_mid_fastfood_cnt = 195;

    public static final int past_day = 196;
    public static final int month_1_large_category_sum = 198;
    public static final int month_1_large_category_name = 199;
    public static final int today = 200;
    public static final int month_1_mid_taxi_sum = 201;
    public static final int month_1_alcohol_type = 204;
    public static final int user_sex = 205;

    public static final int month_0_same_period_percent = 206;
    public static final int month_0_mid_coffee_sum = 207;
    public static final int yesterday_alcohol_sum = 208;

    public static final int three_month_avg = 214;

    public static final int three_month_mid_coffee_week_avg = 216;
    public static final int month_2_mid_taxi_sum = 219;
    public static final int month_3_mid_taxi_sum = 223;
    public static final int three_month_sum = 224;
    public static final int month_0_same_period_more_or_less_str = 225;
    public static final int month_1_same_period_end_day = 226;

    public static final int three_month_book_diff_sum = 227;
    public static final int month_1_large_category_code = 228;
    public static final int month_1_alcohol_type_image_name = 229;
    public static final int three_month_week_avg = 230;
    public static final int three_month_day_avg = 231;
    public static final int week_0_sum = 232;
    public static final int week_1_sum = 233;
    public static final int week_1_percent = 234;
    public static final int yesterday_max_sum = 236;
    public static final int day_of_week = 237;
    public static final int mid_image = 238;
    public static final int same_period_image = 239;

    public static final SparseArray<Result> values = new SparseArray<>();
    public static final SparseArray<ArrayList<Integer>> tranIds = new SparseArray<>();

    public static final int LV0 = 0;
    public static final int NORMAL = 1;
    public static final int FIRSTDOT = 2;
    public static final int PERCENT = 3;

    private MonthlyAnalysis monthlyAnalysis0, monthlyAnalysis1, monthlyAnalysis2, monthlyAnalysis3;

    private WeeklyAnalysis weeklyAnalysis0, weeklyAnalysis1;

    private DailyAnalysis dailyAnalysis1;

    private LastSpentAnalysis movie, nail, hair, hospital;

    void calculate(ArrayList<Transaction> transactions) throws Exception {

        Thread[] threads = new Thread[11];
        monthlyAnalysis0 = new MonthlyAnalysis(transactions, 0);
        threads[0] = new Thread(monthlyAnalysis0);

        monthlyAnalysis1 = new MonthlyAnalysis(transactions, 1);
        threads[1] = new Thread(monthlyAnalysis1);

        monthlyAnalysis2 = new MonthlyAnalysis(transactions, 2);
        threads[2] = new Thread(monthlyAnalysis2);

        monthlyAnalysis3 = new MonthlyAnalysis(transactions, 3);
        threads[3] = new Thread(monthlyAnalysis3);

        weeklyAnalysis0 = new WeeklyAnalysis(transactions, 0);
        threads[4] = new Thread(weeklyAnalysis0);

        weeklyAnalysis1 = new WeeklyAnalysis(transactions, 1);
        threads[5] = new Thread(weeklyAnalysis1);

        dailyAnalysis1 = new DailyAnalysis(transactions, 1);
        threads[6] = new Thread(dailyAnalysis1);

        movie = new LastSpentAnalysis(transactions, Constants.MCODE.MOVIE);
        threads[7] = new Thread(movie);

        nail = new LastSpentAnalysis(transactions, Constants.MCODE.NAIL);
        threads[8] = new Thread(nail);

        hair = new LastSpentAnalysis(transactions, Constants.MCODE.HAIR);
        threads[9] = new Thread(hair);

        hospital = new LastSpentAnalysis(transactions, Constants.MCODE.HOSPITAL, Constants.MCODE.MID_PHARMACY, Constants.MCODE.MID_DENTIST, Constants.MCODE.MID_CLINIC);
        threads[10] = new Thread(hospital);

        for(Thread thread : threads) {
            thread.start();
            thread.join();
        }

        setDefault();

        setYesterday();
        setWeekly();

        setMonth0();
        setMonth1();
        setMonth2();
        setMonth3();

        setThreeMonth();

        setLastSpent();

        setTranIds();
    }

    private void setDefault() {
        values.put(today, new Result(Calendar.getInstance().get(Calendar.DATE), FIRSTDOT));
        values.put(user_sex, new Result("0"));
        values.put(day_of_week, new Result(Calendar.getInstance().get(Calendar.DAY_OF_WEEK), FIRSTDOT));
    }

    private void setMonth0() {
        if(monthlyAnalysis0 == null) return;

        values.put(month_0, new Result(monthlyAnalysis0.monthStr));
        AggregationValue month = monthlyAnalysis0.month.get("");

        if(month != null) {

            values.put(month_0_sum, new Result(month.getSum(), LV0));
            values.put(month_0_cnt, new Result(month.getCnt(), FIRSTDOT));
            values.put(month_0_avg, new Result(month.getAvg(), LV0));
        }

        values.put(month_0_sum_credit, new Result(getAggregate(monthlyAnalysis0.cardType, "1", SUM), LV0));
        values.put(month_0_sum_check, new Result(getAggregate(monthlyAnalysis0.cardType, "0", SUM), LV0));
        values.put(month_0_sum_cash, new Result(getAggregate(monthlyAnalysis0.cardType, "3", SUM), LV0));

        double percent = getPercentValue(month == null? 0 : month.getSum(), monthlyAnalysis1.samePeriodSum);
        values.put(month_0_same_period_percent, new Result(percent, PERCENT));
        if(percent > 0) {
            values.put(month_0_same_period_more_or_less_str, new Result("많이" ));
            values.put(same_period_image, new Result("lv0_monthly_up"));
        } else {
            values.put(month_0_same_period_more_or_less_str, new Result( "적게"));
            values.put(same_period_image, new Result("lv0_monthly_down"));
        }

        values.put(month_0_mid_coffee_sum, new Result(getAggregate(monthlyAnalysis0.mcode, Constants.MCODE.COFFEE + "", SUM), LV0));
        values.put(past_day, new Result(Calendar.getInstance().get(Calendar.DATE), FIRSTDOT));
    }

    private void setMonth1() {
        values.put(month_1, new Result(monthlyAnalysis1.monthStr));
        AggregationValue month = monthlyAnalysis1.month.get("");

        if(month != null) {

            values.put(month_1_sum, new Result(month.getSum(), LV0));
            values.put(month_1_cnt, new Result(month.getCnt(), FIRSTDOT));
            values.put(month_1_avg, new Result(month.getAvg(), LV0));

            values.put(month_1_sum_same_period, new Result(monthlyAnalysis1.samePeriodSum, LV0));
            values.put(month_1_sum_credit, new Result(getAggregate(monthlyAnalysis1.cardType, "1", SUM), LV0));
            values.put(month_1_sum_check, new Result(getAggregate(monthlyAnalysis1.cardType, "0", SUM), LV0));
            values.put(month_1_sum_cash, new Result(getAggregate(monthlyAnalysis1.cardType, "3", SUM), LV0));

            //술
            AggregationValue alcohol = monthlyAnalysis1.mcode.get(ALCOHOL + "");
            if(alcohol != null) {
                values.put(month_1_mid_alcohol_sum, new Result(alcohol.getSum(), LV0));
                values.put(month_1_mid_alcohol_cnt, new Result(alcohol.getCnt(), FIRSTDOT));

                String[] alcohols = AnalysisHelper.getAlcoholType(alcohol.getCnt());
                values.put(month_1_alcohol_type, new Result(alcohols[ALCOHOL_TYPE]));
                values.put(month_1_alcohol_type_image_name, new Result(alcohols[ALCOHOL_TYPE_IMAGE]));
            }


            values.put(month_1_mid_coffee_sum, new Result(getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.COFFEE + "", SUM), LV0));
            values.put(month_1_mid_mart_sum, new Result(getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.MART + "", SUM), LV0));
            values.put(month_1_mid_convenience_sum, new Result(getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.CONVENIENCE + "", SUM), LV0));
            values.put(month_1_mid_taxi_sum, new Result(getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.TAXI + "", SUM), LV0));

            values.put(month_1_same_period_end_day, new Result(Calendar.getInstance().get(Calendar.DATE), FIRSTDOT));

            setLargeCategoryTop3(month.getSum());
            setMidTop3();
        }

    }

    private void setLargeCategoryTop3(double monthSum) {
        // 카테고리 공통
        ArrayList<AggregationValue> larges = new ArrayList<>(monthlyAnalysis1.lcode.values());
        desc(larges);

        int i = 0;

        for(AggregationValue large : larges) {
            if(i == 3) break;

            Result name = new Result(large.getTitle());
            Result sum = new Result(large.getSum(), NORMAL);

            double percentValue = large.getSum() * 100 / monthSum;
            Result percent = new Result(percentValue, PERCENT);

            switch (i) {
                case 0:
                    values.put(month_1_category_first_name, name);
                    values.put(month_1_category_first_sum, sum);
                    values.put(month_1_category_first_percent, percent);
                    break;
                case 1:
                    values.put(month_1_category_second_name, name);
                    values.put(month_1_category_second_sum, sum);
                    values.put(month_1_category_second_percent, percent);
                    break;
                case 2:
                    values.put(month_1_category_third_name, name);
                    values.put(month_1_category_third_sum, sum);
                    values.put(month_1_category_third_percent, percent);
                    break;
            }
            i++;
        }

        //랜덤으로 중분류 선택
        int rand = getRand(0, larges.size() > 3 ? 3 : larges.size());
        AggregationValue large = larges.get(rand);

        values.put(month_1_large_category_code, new Result(large.getKey()));
        values.put(month_1_large_category_sum, new Result(large.getSum(), LV0));
        values.put(month_1_large_category_name, new Result(large.getTitle()));
        values.put(mid_image, new Result(getMidImage(large.getKey())));

    }

    private void setMidTop3() {
        // 중분류의 경우 탑 3중 1개 뽑아서 보여주기
        Result result = values.get(month_1_large_category_code);
        if(result == null) return;
        String lCode = result.getValue();

        result = values.get(month_1_large_category_sum);
        if(result == null) return;
        double largeSum = result.getAmount();

        ArrayList<AggregationValue> mediums = new ArrayList<>(monthlyAnalysis1.mcode.values());
        desc(mediums);

        int i = 0;

        for(AggregationValue medium : mediums) {

            if(lCode.equals(medium.getKey().substring(0,2))) {
                if(i == 3) break;

                Result name = new Result(medium.getTitle());
                Result sum = new Result(medium.getSum(), NORMAL);

                double percentValue = medium.getSum() * 100 / largeSum;
                Result percent = new Result(percentValue, PERCENT);

                switch (i) {
                    case 0:
                        values.put(month_1_mid_category_first_name, name);
                        values.put(month_1_mid_category_first_sum, sum);
                        values.put(month_1_mid_category_first_percent, percent);
                        break;
                    case 1:
                        values.put(month_1_mid_category_second_name, name);
                        values.put(month_1_mid_category_second_sum, sum);
                        values.put(month_1_mid_category_second_percent, percent);
                        break;
                    case 2:
                        values.put(month_1_mid_category_third_name, name);
                        values.put(month_1_mid_category_third_sum, sum);
                        values.put(month_1_mid_category_third_percent, percent);
                        break;
                }
                i++;
            }
        }
    }

    private void setMonth2() {
        values.put(month_2, new Result(monthlyAnalysis2.monthStr));
        AggregationValue month = monthlyAnalysis2.month.get("");

        if(month != null) {

            values.put(month_2_sum, new Result(month.getSum(), LV0));
            values.put(month_2_cnt, new Result(month.getCnt(), FIRSTDOT));
            values.put(month_2_avg, new Result(month.getAvg(), LV0));

            values.put(month_2_mid_alcohol_sum, new Result(getAggregate(monthlyAnalysis2.mcode, ALCOHOL + "", SUM), LV0));
            values.put(month_2_mid_coffee_sum, new Result(getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.COFFEE + "", SUM), LV0));
            values.put(month_2_mid_mart_sum, new Result(getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.MART + "", SUM), LV0));
            values.put(month_2_mid_convenience_sum, new Result(getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.CONVENIENCE + "", SUM), LV0));
            values.put(month_2_mid_taxi_sum, new Result(getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.TAXI + "", SUM), LV0));
        }

    }

    private void setMonth3() {

        values.put(month_3, new Result(monthlyAnalysis3.monthStr));
        AggregationValue month = monthlyAnalysis3.month.get("");

        if(month != null) {

            values.put(month_3_sum, new Result(month.getSum(), LV0));
            values.put(month_3_cnt, new Result(month.getCnt(), FIRSTDOT));
            values.put(month_3_avg, new Result(month.getAvg(), LV0));

            values.put(month_3_mid_alcohol_sum, new Result(getAggregate(monthlyAnalysis3.mcode, ALCOHOL + "", SUM), LV0));
            values.put(month_3_mid_coffee_sum, new Result(getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.COFFEE + "", SUM), LV0));

            values.put(month_3_mid_mart_sum, new Result(getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.MART + "", SUM), LV0));
            values.put(month_3_mid_convenience_sum, new Result(getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.CONVENIENCE + "", SUM), LV0));
            values.put(month_3_mid_taxi_sum, new Result(getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.TAXI + "", SUM), LV0));
        }
    }

    private void setThreeMonth() {

        int threeMonthTotalDay = getThreeMonthTotalDay();// 3 개월 전체 일수

        // 3개월 전체 합 건 평균, 주간평균
        setThreeMonthAggregation(threeMonthTotalDay);

        // 지난3개월 커피 국가
        setThreeMonthCoffeeCountry(threeMonthTotalDay);

        // book
        setThreeMonthBookSum();

        // fastfood
        setThreeMonthFastFood();

        // hair
        setThreeMonthHair(threeMonthTotalDay);

        // nail
        setThreeMonthNail();

        // mart
        setThreeMonthMart();

        // convenience
        setThreeMonthConvenience();

        // movie
        setThreeMonthMovie();

        // taxi
        setThreeMonthTaxi();

        // alcohol
        setThreeMonthAlcohol();

    }

    private int getThreeMonthTotalDay() {
        Calendar before = Calendar.getInstance();
        before.set(Calendar.DATE, 1);
        before.add(Calendar.MONTH, -4);

        Calendar after = Calendar.getInstance();
        after.set(Calendar.DATE, 1);
        after.add(Calendar.MONTH, -1);

        return getDiffDay(before, after);
    }

    private void setThreeMonthAggregation(int totalDay) {

        double m1 = getAggregate(monthlyAnalysis1.month, "", SUM);
        double m2 = getAggregate(monthlyAnalysis2.month, "", SUM);
        double m3 = getAggregate(monthlyAnalysis3.month, "", SUM);

        double threeMonthSum = m1 + m2 + m3;
        int divider = 0;
        if(m3 != 0)
            divider = 3;
        else if(m2 != 0)
            divider = 2;
        else if(m1 != 0)
            divider = 1;

        double threeMonthAvg = divider == 0 ? 0 : threeMonthSum / divider;
        double threeMonthDayAvg = totalDay == 0 ? 0 : threeMonthSum / totalDay;
        double threeMonthWeekAvg = threeMonthDayAvg * 7;

        values.put(three_month_sum, new Result(threeMonthSum, LV0));
        values.put(three_month_week_avg, new Result(threeMonthWeekAvg, LV0));
        values.put(three_month_day_avg, new Result(threeMonthWeekAvg, LV0));
        values.put(three_month_avg, new Result(threeMonthAvg, LV0));

    }

    private void setThreeMonthCoffeeCountry(int totalDay) {

        double s1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.COFFEE + "", SUM);
        double s2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.COFFEE + "", SUM);
        double s3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.COFFEE + "", SUM);
        values.put(three_month_mid_coffee_sum, new Result(s1 + s2 + s3, LV0));

        double morning = monthlyAnalysis1.morningCoffeeSum.getSum() + monthlyAnalysis2.morningCoffeeSum.getSum() + monthlyAnalysis3.morningCoffeeSum.getSum();
        values.put(three_month_mid_coffee_am_sum, new Result(morning, LV0));

        double c1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.COFFEE + "", CNT);
        double c2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.COFFEE + "", CNT);
        double c3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.COFFEE + "", CNT);

        double threeMonthCoffeeCnt = (c1 + c2 + c3);

        double threeMonthCoffeeWeekAvg = totalDay == 0 ? 0 : threeMonthCoffeeCnt * 7 / totalDay;
        String[] coffeeType = getCoffeeCountry(threeMonthCoffeeWeekAvg);

        values.put(three_month_mid_coffee_cnt, new Result(threeMonthCoffeeCnt, FIRSTDOT));
        values.put(three_month_mid_coffee_country, new Result(coffeeType[COFFEE_TYPE_COUNTRY]));
        values.put(three_month_mid_coffee_country_value, new Result(coffeeType[COFFEE_TYPE_COUNTRY_AMOUNT]));

        values.put(three_month_mid_coffee_week_avg, new Result(threeMonthCoffeeWeekAvg, FIRSTDOT));

    }

    private void setThreeMonthBookSum() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.BOOK + "", SUM);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.BOOK + "", SUM);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.BOOK + "", SUM);

        double threeMonthSum = m1 + m2 + m3;

        double diff = threeMonthSum - 54300;

        values.put(three_month_book_sum, new Result(threeMonthSum, LV0));
        values.put(three_month_book_diff_sum, new Result(diff, LV0));
    }

    private void setThreeMonthFastFood() {

        double l1 = getAggregate(monthlyAnalysis1.lcode, Constants.LCODE.FOOD + "", CNT);
        double l2 = getAggregate(monthlyAnalysis2.lcode, Constants.LCODE.FOOD + "", CNT);
        double l3 = getAggregate(monthlyAnalysis3.lcode, Constants.LCODE.FOOD + "", CNT);

        double lcnt = l1 + l2 + l3;
        if(lcnt == 0) return;

        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.FASTFOOD + "", CNT);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.FASTFOOD + "", CNT);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.FASTFOOD + "", CNT);

        double mcnt = m1 + m2 + m3;

        double percent = mcnt * 100 / lcnt;

        values.put(three_month_large_food_cnt, new Result(lcnt, FIRSTDOT));
        values.put(three_month_mid_fastfood_cnt, new Result(mcnt, FIRSTDOT));
        values.put(three_month_mid_fastfood_percent, new Result(percent, PERCENT));

        HashMap<String, AggregationValue> totalFastFoods = new HashMap<>();
        if(monthlyAnalysis1.fastfood != null)
            totalFastFoods.putAll(monthlyAnalysis1.fastfood);
        if(monthlyAnalysis2.fastfood != null)
            totalFastFoods.putAll(monthlyAnalysis2.fastfood);
        if(monthlyAnalysis2.fastfood != null)
            totalFastFoods.putAll(monthlyAnalysis3.fastfood);

        ArrayList<AggregationValue> keywords = new ArrayList<>(totalFastFoods.values());
        desc(keywords);

        int i = 0;

        for(AggregationValue keyword : keywords) {
            if(i == 3) break;

            Result name = new Result(keyword.getTitle());
            Result cnt = new Result(keyword.getCnt(), FIRSTDOT);

            switch (i) {
                case 0:
                    values.put(three_month_first_mid_fastfood_keyword, name);
                    values.put(three_month_first_mid_fastfood_cnt, cnt);
                    break;
                case 1:
                    values.put(three_month_second_mid_fastfood_keyword, name);
                    values.put(three_month_second_mid_fastfood_cnt, cnt);
                    break;
                case 2:
                    values.put(three_month_third_mid_fastfood_keyword, name);
                    values.put(three_month_third_mid_fastfood_cnt, cnt);
                    break;
            }
            i++;
        }

    }

    private void setThreeMonthHair(int totalDay) {

        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.HAIR + "", CNT);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.HAIR + "", CNT);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.HAIR + "", CNT);

        double hairCnt = m1 + m2 + m3;
        double avg = hairCnt == 0 ? 0 : totalDay / hairCnt;

        values.put(three_month_hair_avg_cnt, new Result(avg, FIRSTDOT));

    }

    private void setThreeMonthMovie() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.MOVIE + "", CNT);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.MOVIE + "", CNT);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.MOVIE + "", CNT);

        double movieCnt = m1 + m2 + m3;

        values.put(three_month_movie_cnt, new Result(movieCnt, FIRSTDOT));

    }

    private void setThreeMonthNail() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.NAIL + "", CNT);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.NAIL + "", CNT);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.NAIL + "", CNT);

        double nailCnt = m1 + m2 + m3;
        values.put(three_month_nail_cnt, new Result(nailCnt, FIRSTDOT));

    }

    private void setThreeMonthTaxi() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.TAXI + "", SUM);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.TAXI + "", SUM);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.TAXI + "", SUM);

        double taxiSum = m1 + m2 + m3;
        double taxiAmSum = monthlyAnalysis1.morningTaxiSum.getSum() + monthlyAnalysis2.morningTaxiSum.getSum() + monthlyAnalysis3.morningTaxiSum.getSum();

        values.put(three_month_mid_taxi_sum, new Result(taxiSum, LV0));
        values.put(three_month_mid_taxi_am_sum, new Result(taxiAmSum, LV0));
    }

    private void setThreeMonthConvenience() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.CONVENIENCE + "", SUM);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.CONVENIENCE + "", SUM);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.CONVENIENCE + "", SUM);

        double conSum = m1 + m2 + m3;
        values.put(three_month_mid_convenience_sum, new Result(conSum, LV0));
    }

    private void setThreeMonthMart() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.MART + "", SUM);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.MART + "", SUM);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.MART + "", SUM);

        double martSum = m1 + m2 + m3;
        values.put(three_month_mid_mart_sum, new Result(martSum, LV0));
    }

    private void setThreeMonthAlcohol() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, ALCOHOL + "", SUM);
        double m2 = getAggregate(monthlyAnalysis2.mcode, ALCOHOL + "", SUM);
        double m3 = getAggregate(monthlyAnalysis3.mcode, ALCOHOL + "", SUM);

        double alcoholSum = m1 + m2 + m3;
        values.put(three_month_mid_alcohol_sum, new Result(alcoholSum, LV0));
    }

    private void setYesterday() {

        values.put(yesterday_sum, new Result(getAggregate(dailyAnalysis1.yesterday, "", SUM), LV0));
        values.put(yesterday_alcohol_sum, new Result(getAggregate(dailyAnalysis1.alcohol, "", SUM), LV0));
        if(dailyAnalysis1.maxTransaction != null) {
            values.put(yesterday_max_keyword, new Result(dailyAnalysis1.maxTransaction.getTransaction().getKeyword()));
            values.put(yesterday_max_sum, new Result(dailyAnalysis1.maxTransaction.getTransaction().getSpentMoney(), NORMAL));
        }
    }

    private void setWeekly() {
        values.put(week_0_sum, new Result(getAggregate(weeklyAnalysis0.weekly, "", SUM), LV0));
        values.put(week_1_sum, new Result(getAggregate(weeklyAnalysis1.weekly, "", SUM), LV0));

        double sum = getAggregate(weeklyAnalysis1.weekly, "", SUM);
        double amount = getFuncAmount(three_month_week_avg);
        double percent = getPercentValue(sum, amount);
        values.put(week_1_percent, new Result(percent, PERCENT));
    }

    private void setLastSpent() {
        if(hospital.lastTransaction != null) {
            values.put(last_hospital_date, new Result(hospital.lastTransaction.getTransaction().getSpentDate()));
            values.put(last_hospital_diff_day, new Result(hospital.difDay, FIRSTDOT));
        }

        if(movie.lastTransaction != null) {
            values.put(last_movie_date, new Result(movie.lastTransaction.getTransaction().getSpentDate()));
            values.put(last_movie_diff_day, new Result(movie.difDay, FIRSTDOT));
            values.put(last_movie_keyword, new Result(movie.lastTransaction.getTransaction().getKeyword()));
        }

        if(nail.lastTransaction != null) {
            values.put(last_nail_date, new Result(nail.lastTransaction.getTransaction().getSpentDate()));
            values.put(last_nail_diff_day, new Result(nail.difDay, FIRSTDOT));
            values.put(last_nail_keyword, new Result(nail.lastTransaction.getTransaction().getKeyword()));
        }

        if(hair.lastTransaction != null) {
            values.put(last_hair_date, new Result(hair.lastTransaction.getTransaction().getSpentDate()));
            values.put(last_hair_diff_day, new Result(hair.difDay, FIRSTDOT));
            values.put(last_hair_keyword, new Result(hair.lastTransaction.getTransaction().getKeyword()));
        }
    }


    private void setTranIds() {
        ArrayList<Integer> ids;
        AggregationValue value;

        tranIds.put(last_nail_diff_day, getTranIds(nail.filteredTransactions));
        tranIds.put(last_movie_diff_day, getTranIds(movie.filteredTransactions));
        tranIds.put(179, getTranIds(hair.filteredTransactions));
        tranIds.put(164, getTranIds(hospital.filteredTransactions));
        tranIds.put(164, getTranIds(hospital.filteredTransactions));

        ids = new ArrayList<>();
        ids.addAll(getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.BOOK));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis2.mcode, "" + Constants.MCODE.BOOK));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis3.mcode, "" + Constants.MCODE.BOOK));
        tranIds.put(137, ids);


        ids = new ArrayList<>();
        ids.addAll(getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.FASTFOOD));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis2.mcode, "" + Constants.MCODE.FASTFOOD));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis3.mcode, "" + Constants.MCODE.FASTFOOD));

        tranIds.put(three_month_large_food_cnt, ids);

        value = monthlyAnalysis1.month.get("");
        tranIds.put(month_1_large_category_sum, value == null ? new ArrayList<Integer>() : value.getTranIds());

        ids = new ArrayList<>();
        ids.addAll(getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.COFFEE));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis2.mcode, "" + Constants.MCODE.COFFEE));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis3.mcode, "" + Constants.MCODE.COFFEE));
        tranIds.put(three_month_mid_coffee_cnt, ids);

        ids = new ArrayList<>();
        ids.addAll(monthlyAnalysis1.morningCoffeeSum.getIds());
        ids.addAll(monthlyAnalysis2.morningCoffeeSum.getIds());
        ids.addAll(monthlyAnalysis3.morningCoffeeSum.getIds());
        tranIds.put(177, ids);

        ids = new ArrayList<>();
        ids.addAll(monthlyAnalysis1.morningTaxiSum.getIds());
        ids.addAll(monthlyAnalysis2.morningTaxiSum.getIds());
        ids.addAll(monthlyAnalysis3.morningTaxiSum.getIds());
        tranIds.put(136, ids);

        tranIds.put(55, getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.COFFEE));
        tranIds.put(54, getAggregatedTranIds(monthlyAnalysis1.mcode, "" + ALCOHOL));
        tranIds.put(56, getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.MART));
        tranIds.put(57, getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.CONVENIENCE));
        tranIds.put(201, getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.TAXI));


        tranIds.put(5, getAggregatedTranIds(monthlyAnalysis0.cardType, "1"));
        tranIds.put(33, getAggregatedTranIds(monthlyAnalysis1.cardType, "1"));

        tranIds.put(233, getAggregatedTranIds(weeklyAnalysis1.weekly, ""));

        ids = new ArrayList<>();
        ids.addAll(getAggregatedTranIds(monthlyAnalysis1.month, ""));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis2.month, "" ));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis3.month, ""));
        tranIds.put(224, ids);

        ids = new ArrayList<>();
        ids.addAll(getAggregatedTranIds(monthlyAnalysis0.month, ""));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis1.month, "" ));
        tranIds.put(2, ids);

        ids = new ArrayList<>();
        ids.addAll(getAggregatedTranIds(monthlyAnalysis1.month, "" ));
        tranIds.put(29, ids);

        tranIds.put(174, getAggregatedTranIds(dailyAnalysis1.yesterday, ""));

        tranIds.put(208, getAggregatedTranIds(dailyAnalysis1.alcohol, ""));


    }



}
