package com.tenqube.visual_third;

import android.support.annotation.NonNull;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.ui.OnResultListener;

public interface VisualService {

    /**
     * 처음 가입 무조건 실행 해야함
     * @param custId 클립 사용자 아이디
     */
    void signUp(@NonNull String custId, @NonNull OnResultListener onResultListener) throws ParameterException;

    /**
     * 비주얼 가계부 화면 호출
     * 가입되지 않은 사용자 가입처리를 위해 파라미터 추가
     *
     * @param custId 클립 사용자 아이디 가입되지 않은경우 signUp 호출
     * @param onResultListener 미가입시 가입결과를 위한 콜백 함수
     */
    void startVisual(@NonNull String custId, @NonNull OnResultListener onResultListener) throws ParameterException, SecurityException;

    /**
     * 로그 확인을 위한 디버그 적용 함수
     * @param isDebug 디버그 여부
     */
    void setDebugMode(boolean isDebug);

    /**
     * SDK초기화 함수 개발 전용
     */
    void initSDK();

}
