/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;

public class TransactionPopupActivity
extends Activity {
    public static final String ARG_TRANSACTION = "ARG_TRANSACTION";

    public static void startActivity(Context context, TransactionPopupInfo transactionPopupInfo) throws ParameterException, AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        if (transactionPopupInfo == null) {
            throw new ParameterException("Check transactionPopupInfo.");
        }
        if (!PrefManager.getInstance(context).isEnabled("TENQUBE_TRAN_POPUP", true)) {
            return;
        }
        Intent intent = new Intent(context, TransactionPopupActivity.class);
        intent.addFlags(0x4020000);
        intent.putExtra(ARG_TRANSACTION, (Serializable)transactionPopupInfo);
        context.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            final TransactionPopupInfo transactionPopupInfo = (TransactionPopupInfo)this.getIntent().getSerializableExtra(ARG_TRANSACTION);
            if (transactionPopupInfo == null && !PrefManager.getInstance((Context)this).isEnabled("TENQUBE_TRAN_POPUP", true)) {
                this.finish();
                return;
            }
            this.requestWindowFeature(1);
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.setContentView(R.layout.activity_transaction_popup);
            DisplayMetrics dm = new DisplayMetrics();
            this.getWindowManager().getDefaultDisplay().getMetrics(dm);
            TextView companyTitleTextView = (TextView)this.findViewById(R.id.company_title);
            companyTitleTextView.setText((CharSequence)transactionPopupInfo.getCompanyTitle());
            TextView companyAddressTextView = (TextView)this.findViewById(R.id.company_address);
            companyAddressTextView.setVisibility(TextUtils.isEmpty((CharSequence)transactionPopupInfo.getCompanyAddress()) ? 8 : 0);
            companyAddressTextView.setText((CharSequence)transactionPopupInfo.getCompanyAddress());
            TextView spentDateTextView = (TextView)this.findViewById(R.id.spent_date);
            spentDateTextView.setText((CharSequence)transactionPopupInfo.getSpentDate());
            TextView paymentTextView = (TextView)this.findViewById(R.id.payment);
            paymentTextView.setText((CharSequence)transactionPopupInfo.getPayment());
            TextView installmentTextView = (TextView)this.findViewById(R.id.installment);
            installmentTextView.setText((CharSequence)transactionPopupInfo.getInstallmentStr());
            TextView spentMoneyTextView = (TextView)this.findViewById(R.id.spent_money);
            spentMoneyTextView.setText((CharSequence)transactionPopupInfo.getSpentMoneyStr());
            this.findViewById(R.id.setting).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        VisualWebActivity.startActivity(TransactionPopupActivity.this.getApplicationContext(), "#settings=true");
                    }
                    catch (AuthException e) {
                        e.printStackTrace();
                        TransactionPopupActivity.this.finish();
                    }
                }
            });
            this.findViewById(R.id.go_detail).setOnClickListener(new View.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClick(View view) {
                    try {
                        VisualRepository repository = VisualRepository.getInstance(TransactionPopupActivity.this.getApplicationContext());
                        int tranId = repository.loadTranId(transactionPopupInfo.getTransaction().identifier);
                        if (tranId == 0) {
                            return;
                        }
                        Category category = repository.loadCategory(transactionPopupInfo.getCategoryCode());
                        if (category == null) {
                            return;
                        }
                        int cardId = repository.loadCardId(transactionPopupInfo.getTransaction().cardName, transactionPopupInfo.getTransaction().cardType, transactionPopupInfo.getTransaction().cardSubType);
                        String path = Utils.makeDialogPath(tranId, transactionPopupInfo.getTransaction().keyword, category.getLarge(), category.getMedium(), category.getLargeCode(), category.getMediumCode(), transactionPopupInfo.getTransaction().spentDate, transactionPopupInfo.getTransaction().spentMoney, transactionPopupInfo.getTransaction().installmentCount, cardId, transactionPopupInfo.getTransaction().memo, transactionPopupInfo.getTransaction().dwType == 1 ? "expense" : "income", "popup");
                        VisualWebActivity.startActivity(TransactionPopupActivity.this.getApplicationContext(), path);
                    }
                    catch (AuthException e) {
                        e.printStackTrace();
                    }
                    finally {
                        TransactionPopupActivity.this.finish();
                    }
                }
            });
            this.findViewById(R.id.close).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    TransactionPopupActivity.this.finish();
                }
            });
            ImageView categoryImageView = (ImageView)this.findViewById(R.id.category);
            categoryImageView.setImageResource(Utils.getCategoryIcon(transactionPopupInfo.getLargeCode()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

