/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.model.js.SelectBoxInfo;
import com.tenqube.visual_third.model.js.SelectBoxRequest;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;

public class BottomDialog {
    private OnBottomListener bottomListener;
    private final Activity activity;
    private BottomSheetDialog bottomSheetDialog;
    private int peekHeight;

    BottomDialog(Activity activity) {
        this.activity = activity;
    }

    public void setBottomListener(OnBottomListener bottomListener) {
        this.bottomListener = bottomListener;
        this.peekHeight = Utils.getDeviceHeight(this.activity) / 2 - Utils.dpToPx(24);
    }

    public void showBottomDialog(SelectBoxRequest selectBoxRequest) {
        try {
            View view;
            if (selectBoxRequest == null) {
                return;
            }
            if (this.bottomSheetDialog == null) {
                this.bottomSheetDialog = new BottomSheetDialog((Context)this.activity);
                this.bottomSheetDialog.getWindow().setSoftInputMode(32);
            }
            if (!this.isShowing() && (view = this.activity.getLayoutInflater().inflate(R.layout.bottom_sheet_view, null)) != null) {
                TextView titleTextView = (TextView)view.findViewById(R.id.title);
                titleTextView.setText((CharSequence)selectBoxRequest.getTitle());
                view.findViewById(R.id.close).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        BottomDialog.this.dismiss();
                    }
                });
                RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
                if (selectBoxRequest.getData().size() > 3) {
                    FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
                    params.height = this.peekHeight;
                    recyclerView.setLayoutParams((ViewGroup.LayoutParams)params);
                }
                LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this.activity);
                recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
                recyclerView.setHasFixedSize(true);
                recyclerView.setAdapter((RecyclerView.Adapter)new BottomAdapter(selectBoxRequest.getData(), this.bottomListener));
                this.bottomSheetDialog.setContentView(view);
                BottomSheetBehavior mBehavior = BottomSheetBehavior.from((View)((View)view.getParent()));
                mBehavior.setPeekHeight(this.peekHeight);
                this.bottomSheetDialog.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        if (this.isShowing()) {
            this.bottomSheetDialog.dismiss();
        }
    }

    private boolean isShowing() {
        return this.bottomSheetDialog != null && this.bottomSheetDialog.isShowing();
    }

    static class BottomViewHolder
    extends RecyclerView.ViewHolder {
        LinearLayout container;
        TextView nameTextView;

        BottomViewHolder(View convertView, final OnClickListener onClickListener) {
            super(convertView);
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (onClickListener != null && BottomViewHolder.this.getAdapterPosition() != -1) {
                        onClickListener.onClick(BottomViewHolder.this.getAdapterPosition());
                    }
                }
            });
            this.container = (LinearLayout)convertView.findViewById(R.id.container);
            this.nameTextView = (TextView)convertView.findViewById(R.id.name);
        }

        void onBind(SelectBoxInfo selectBoxInfo) {
            if (selectBoxInfo.isSelected()) {
                int selectedColor = selectBoxInfo.getSelectedColor() == 0 ? R.color.colorPopupRed : selectBoxInfo.getSelectedColor();
                Utils.changeColor(this.container, selectedColor);
                this.nameTextView.setTextColor(this.nameTextView.getContext().getResources().getColor(selectedColor));
            } else {
                Utils.changeColor(this.container, R.color.colorPopupGrey);
                this.nameTextView.setTextColor(this.nameTextView.getContext().getResources().getColor(17170444));
            }
            this.nameTextView.setText((CharSequence)selectBoxInfo.getName());
        }
    }

    public static class BottomAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder>
    implements OnClickListener {
        private final ArrayList<SelectBoxInfo> selectBoxInfos;
        private final OnBottomListener bottomListener;
        private int selectedPos = -1;

        BottomAdapter(@NonNull ArrayList<SelectBoxInfo> selectBoxInfos, OnBottomListener bottomListener) {
            this.selectBoxInfos = selectBoxInfos;
            this.bottomListener = bottomListener;
            this.setSelectedPos();
        }

        private void setSelectedPos() {
            int size = this.selectBoxInfos.size();
            for (int i = 0; i < size; ++i) {
                if (!this.selectBoxInfos.get(i).isSelected()) continue;
                this.selectedPos = i;
                return;
            }
        }

        @NonNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            ViewGroup view = (ViewGroup)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.adapter_select_box, parent, false);
            return new BottomViewHolder((View)view, this);
        }

        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            try {
                SelectBoxInfo selectBoxInfo = this.selectBoxInfos.get(position);
                selectBoxInfo.setSelected(this.selectedPos == position);
                BottomViewHolder bHolder = (BottomViewHolder)holder;
                bHolder.onBind(selectBoxInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public int getItemCount() {
            return this.selectBoxInfos == null ? 0 : this.selectBoxInfos.size();
        }

        @Override
        public void onClick(int position) {
            this.selectedPos = position;
            this.notifyItemChanged(position);
            if (this.bottomListener != null) {
                this.bottomListener.onItemSelected(this.selectBoxInfos.get(position));
            }
        }
    }

    static interface OnClickListener {
        public void onClick(int var1);
    }

    public static interface OnBottomListener {
        public void onItemSelected(SelectBoxInfo var1);
    }
}

