package com.tenqube.visual_third.model.api;


import android.text.TextUtils;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;
import java.util.ArrayList;

import tenqube.parser.constants.Constants;

import static com.tenqube.visual_third.util.Validator.in;
import static com.tenqube.visual_third.util.Validator.isDate;
import static com.tenqube.visual_third.util.Validator.isStr;

public class SearchCompanyRequest implements Serializable {

    private ArrayList<Transaction> transactions;

    public ArrayList<Transaction> getTransactions() {
        return transactions;
    }

    public SearchCompanyRequest(ArrayList<Transaction> transactions) {
        this.transactions = transactions;
    }

    public static class Transaction  {
        @SerializedName("id")
        String identifier;

        @SerializedName("keyword")
        String keyword;

        @Expose
        String type;

        @Expose
        String at;

        @Expose
        String method;

        @Expose
        double amount;

        @Expose
        String amountType;

        @Expose
        double lat;

        @SerializedName("long")
        double lng;

        @Expose
        private Integer lCode;

        @Expose
        private Integer mCode;


        public String getIdentifier() {
            return identifier;
        }

        public Transaction(tenqube.parser.model.Transaction transaction) throws ParameterException {
            if(transaction == null)
                throw new ParameterException("transaction is null");

            setIdentifier(transaction.identifier);
            setKeyword(transaction.keyword);
            setType(transaction.dwType == Constants.DWType.DEPOSIT.ordinal() ? "deposit" : "withdraw");
            setAt(transaction.spentDate);
            setMethod(transaction.cardType == 0 ? "debit" : transaction.cardType == 1 ? "credit" : "account");
            setAmount(transaction.spentMoney);
            setAmountType(TextUtils.isEmpty(transaction.currency) || "none".equals(transaction.currency) ? "KRW" : transaction.currency);
            setLat(transaction.spentLatitude);
            setLng(transaction.spentLongitude);
        }

        public Transaction(JoinedTransaction transaction) throws ParameterException {
            if(transaction == null || transaction.getTransaction() == null)
                throw new ParameterException("check transaction");

            setIdentifier("" + transaction.getTransaction().getIdentifier());
            setKeyword(transaction.getTransaction().getKeyword());
            setType(transaction.getTransaction().getDwType() == Constants.DWType.DEPOSIT.ordinal() ? "deposit" : "withdraw");
            setAt(transaction.getTransaction().getSpentDate());
            setMethod(transaction.getCard().getType() == 0 ? "debit" : transaction.getCard().getType() == 1 ? "credit" : "account");
            setAmount(transaction.getTransaction().getSpentMoney());
            setAmountType(TextUtils.isEmpty(transaction.getTransaction().getCurrency()) || "none".equals(transaction.getTransaction().getCurrency()) ? "KRW" : transaction.getTransaction().getCurrency());
            setLat(transaction.getTransaction().getLat());
            setLng(transaction.getTransaction().getLng());
        }


        private void setIdentifier(String identifier) throws ParameterException {
            isStr(identifier, 50);
            this.identifier = identifier;
        }

        private void setKeyword(String keyword) throws ParameterException {
            keyword = TextUtils.isEmpty(keyword) ? "내용없음":keyword;
            isStr(keyword, 50);
            this.keyword = keyword;
        }

        private void setType(String type) throws ParameterException {
            in(type ,"withdraw", "deposit");
            this.type = type;
        }

        private void setAt(String at) throws ParameterException {
            isDate(at);
            this.at = at;
        }

        private void setMethod(String method) throws ParameterException {
            in(method ,"credit", "debit", "account");
            this.method = method;
        }

        private void setAmount(double amount) {
            this.amount = amount;
        }

        private void setAmountType(String amountType) throws ParameterException {
            isStr(amountType, 3);
            this.amountType = amountType;
        }

        private void setLat(double lat) {
            this.lat = lat == 0 ? -1 : lat;
        }

        private void setLng(double lng) {
            this.lng = lng == 0 ? -1 : lng;
        }

        public void setlCode(int lCode) {
            if(String.valueOf(lCode).length() == 2) this.lCode = lCode;
        }

        public void setmCode(int mCode) {
            if(String.valueOf(mCode).length() == 2) this.mCode = mCode;
        }


    }
}
