package com.tenqube.visual_third.model.analysis;

import static com.tenqube.visual_third.analysis.AnalysisHelper.getLv0Currency;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getNumber;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getNumberFirst;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getPercent;

public class Result {

    private String displayValue;
    private String value;
    private double amount;

    public Result(String value) {
        this.value = value;
        this.displayValue = value;
    }

    public Result(String value, int type) {
        this.value = value;
        if(type != -1) setDisplayValue(type);
    }

    public Result(double value, int type) {
        this.amount = value;
        this.value = "" + value;
        if(type != -1) setDisplayValue(type);
    }

    public double getAmount() {
        return amount;
    }

    private void setDisplayValue(int type) {
        try {
            double value = Double.parseDouble(this.value);
            if(type == 0) {
                this.displayValue = getLv0Currency(value);
            } else if (type == 1) {
                this.displayValue = getNumber(value);
            } else if (type == 2) {
                this.displayValue = getNumberFirst(value);
            } else {
                this.displayValue = getPercent(value);
            }
        } catch (NumberFormatException e) {

        }
    }

    /**
     * @return 보여질 값
     */
    public String getDisplayValue() {
        return displayValue;
    }

    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return "Result{" +
                "displayValue='" + displayValue + '\'' +
                ", value='" + value + '\'' +
                ", amount=" + amount +
                '}';
    }
}
