package com.tenqube.visual_third.analysis;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.model.analysis.AggregationValue;
import com.tenqube.visual_third.model.analysis.Morning;
import com.tenqube.visual_third.model.analysis.Transaction;

import java.util.ArrayList;
import java.util.HashMap;

import static com.tenqube.visual_third.analysis.AnalysisHelper.aggregate;
import static com.tenqube.visual_third.analysis.AnalysisHelper.filterTransactions;
import static com.tenqube.visual_third.analysis.AnalysisHelper.filterTransactionsMcode;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getMaxKeyword;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getMonth;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getMorningSum;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getSamePeriodSum;

/**
 * Created by sagwangjin on 2018. 7. 22..
 */

public class MonthlyAnalysis implements Runnable {
    private final int before;
    private final ArrayList<Transaction> transactions;

    public String monthStr;

    public HashMap<String, AggregationValue> month;
    public HashMap<String, AggregationValue> cardType;
    double samePeriodSum;
    public HashMap<String, AggregationValue> lcode;
    public HashMap<String, AggregationValue> mcode;

    public HashMap<String, AggregationValue> fastfood;

    public Transaction maxTransaction;

    Morning morningCoffeeSum;
    Morning morningTaxiSum;


    public MonthlyAnalysis(ArrayList<Transaction> transactions, int before) {
        this.transactions = transactions;
        this.before = before;
    }

    @Override
    public void run() {

        monthStr = getMonth(before) + "";
        // 월간
        ArrayList<Transaction> filteredTransactions = filterTransactions(transactions, before); //이번달

        month = aggregate(filteredTransactions, Constants.AggregateType.NONE);

        if(before != 0) samePeriodSum = getSamePeriodSum(filteredTransactions, before); // month_1_sum_same_period

        cardType = aggregate(filteredTransactions, Constants.AggregateType.CARD_TYPE);

        if(before == 0) maxTransaction = getMaxKeyword(filteredTransactions);

        lcode = aggregate(filteredTransactions, Constants.AggregateType.LCODE);

        mcode = aggregate(filteredTransactions, Constants.AggregateType.MCODE);

        fastfood = aggregate(filterTransactionsMcode(filteredTransactions, Constants.MCODE.FASTFOOD), Constants.AggregateType.KEYWORD);

        morningCoffeeSum = getMorningSum(filteredTransactions, Constants.MCODE.COFFEE);
        morningTaxiSum = getMorningSum(filteredTransactions, Constants.MCODE.TAXI);

    }

}
