package com.tenqube.visual_third.repository;

import android.content.Context;

import com.tenqube.visual_third.db.DatabaseHelper;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.dao.ContentsDao;
import com.tenqube.visual_third.entity.Contents;

import java.util.ArrayList;

public class AnalysisRepository {

    private static AnalysisRepository mInstance;
    private final ContentsDao contentsDao;

    public static AnalysisRepository getInstance(Context context){
        synchronized (AnalysisRepository.class) {
            if(mInstance == null){
                mInstance = new AnalysisRepository(context);
            }
        }
        return mInstance;
    }

    private AnalysisRepository(Context context) {
        DatabaseHelper dbHelper = DatabaseHelper.getInstance(context);
        Db db = new Db(dbHelper.getWritableDatabase(), dbHelper.getReadableDatabase());
        this.contentsDao = new ContentsDao(db);
    }

    public ArrayList<Contents> loadContents(int lCode) {
        return contentsDao.loadContents(lCode);
    }


}
