package com.tenqube.visual_third.parser.loader;

import android.content.Context;

import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.repository.VisualRepository;

import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParsingRule;

import static com.tenqube.visual_third.Constants.RULE_VERSION;
import static com.tenqube.visual_third.manager.PrefManager.PARSING_RULE_VERSION;

class BaseLoader {

    final Context mContext;
    ParserService parserService;
    VisualApi api;
    PrefManager prefManager;
    VisualRepository repository;

    BaseLoader(Context context) {
        this.mContext = context;

        this.parserService = ParserService.getInstance(context);
        parserService.setDebugMode(true);
        this.api = VisualApi.getInstance(context);
        this.repository = VisualRepository.getInstance(context);
        this.prefManager = PrefManager.getInstance(context);
    }

    void syncParsingRule() {
        ParsingRule parsingRule = api.syncParsingRule(prefManager.loadIntValue(PARSING_RULE_VERSION, RULE_VERSION));

        if(parsingRule != null) {
            parserService.syncParsingRule(parsingRule);
            prefManager.saveIntValue(PARSING_RULE_VERSION, parsingRule.ruleVersion);
        }

    }

}
