package com.tenqube.visual_third.db;

import android.content.Context;
import android.content.res.AssetManager;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;

import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.Contents;
import com.tenqube.visual_third.entity.UserCategory;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;
import static tenqube.parser.util.LogUtil.makeLogTag;

public class DatabaseHelper extends SQLiteOpenHelper {

    private static DatabaseHelper mInstance = null;
    private static final String DATABASE_NAME = "visual.db";
    private static final int DATABASE_VERSION = 1;
    private static final String TAG = makeLogTag(DatabaseHelper.class);
    private Context mContext;



    public static DatabaseHelper getInstance(Context context) {
        synchronized (DatabaseHelper.class) {
            if (mInstance == null) {
                mInstance = new DatabaseHelper(context);
            }
            return mInstance;
        }
    }

    private DatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        mContext = context;
    }

    @Override
    public void onCreate(SQLiteDatabase db) throws SQLiteException {
        // create table
        db.execSQL(ReaderContract.CardTable.SQL_CREATE_ENTRIES);
        db.execSQL(ReaderContract.UserCategoryTable.SQL_CREATE_ENTRIES);
        db.execSQL(ReaderContract.CategoryTable.SQL_CREATE_ENTRIES);
        db.execSQL(ReaderContract.TransactionsTable.SQL_CREATE_ENTRIES);
//        db.execSQL(ReaderContract.ContentsTable.SQL_CREATE_ENTRIES);

        // index
        db.execSQL(ReaderContract.CardTable.indexing);
        db.execSQL(ReaderContract.TransactionsTable.indexing);
//        db.execSQL(ReaderContract.ContentsTable.indexing);

        // default value
        insertCategories(db);
        insertUserCategories(db);

    }

    private void insertCategories(SQLiteDatabase db) throws SQLiteException {

        if(db != null) {
            ArrayList<String> values = new ArrayList<>();
            AssetManager am = mContext.getAssets();
            InputStream inStream;
            int i  = 0;
            try {
                inStream = am.open("categories.tsv");
                BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
                String line ;
                while ((line = buffer.readLine()) != null) {
                    if(i == 0){
                        i++;
                        continue;
                    }

                    String[] colums = line.split("\t");
                    Category category = new Category(
                            Integer.parseInt(colums[0]),
                            Integer.parseInt(colums[1]),
                            colums[2],
                            colums[3],
                            colums[4]);

                    values.add(category.getInsertValue());
                    i++;
                }

                if(!values.isEmpty()) {
                    String insertQuery = ReaderContract.CategoryTable.INSERT_QUERY + TextUtils.join(",", values);
                    db.execSQL(insertQuery);
                    values.clear();
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void insertUserCategories(SQLiteDatabase db) throws SQLiteException {
        // 대분류 목록 가져온후
        // 디폴트 값 넣어주기
        ArrayList<String> values = new ArrayList<>();
        values.add(new UserCategory(1, 101010, false, false).getInsertValue());
        values.add(new UserCategory(2, 221010, false, false).getInsertValue());
        values.add(new UserCategory(3, 241010, false, false).getInsertValue());
        values.add(new UserCategory(4, 261010, false, false).getInsertValue());
        values.add(new UserCategory(5, 321010, false, false).getInsertValue());
        values.add(new UserCategory(6, 341010, false, false).getInsertValue());
        values.add(new UserCategory(7, 361010, false, false).getInsertValue());
        values.add(new UserCategory(8, 421010, false, false).getInsertValue());
        values.add(new UserCategory(9, 441010, false, false).getInsertValue());
        values.add(new UserCategory(10, 461010, false, false).getInsertValue());
        values.add(new UserCategory(11, 521010, false, false).getInsertValue());
        values.add(new UserCategory(12, 541010, false, false).getInsertValue());
        values.add(new UserCategory(13, 561010, false, false).getInsertValue());
        values.add(new UserCategory(14, 621010, false, false).getInsertValue());
        values.add(new UserCategory(15, 641010, false, false).getInsertValue());
        values.add(new UserCategory(16, 661010, false, false).getInsertValue());
        values.add(new UserCategory(17, 821010, false, false).getInsertValue());
        values.add(new UserCategory(18, 841010, false, false).getInsertValue());
        values.add(new UserCategory(19, 881010, true, false).getInsertValue());
        values.add(new UserCategory(20, 901010, false, false).getInsertValue());
        values.add(new UserCategory(21, 921010, false, false).getInsertValue());
        values.add(new UserCategory(22, 941010, false, false).getInsertValue());
        values.add(new UserCategory(23, 961010, false, false).getInsertValue());
        values.add(new UserCategory(24, 981010, true, false).getInsertValue());

        String insertQuery = ReaderContract.UserCategoryTable.INSERT_QUERY + TextUtils.join(",", values);
        LOGI(TAG, "insertUserCategories:" + insertQuery, mIsDebug);
        db.execSQL(insertQuery);
        values.clear();

    }

//    private void insertContents(SQLiteDatabase db) throws SQLiteException {
//
//        if(db != null) {
//            ArrayList<String> values = new ArrayList<>();
//            AssetManager am = mContext.getAssets();
//            InputStream inStream;
//            int i  = 0;
//            try {
//                inStream = am.open("contents.tsv");
//                BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
//                String line ;
//                while ((line = buffer.readLine()) != null) {
//                    if(i == 0){
//                        i++;
//                        continue;
//                    }
//
//                    String[] colums = line.split("\t");
//                    Contents contents = new Contents(
//                            Integer.parseInt(colums[0]),
//                            Integer.parseInt(colums[1]),
//                            Integer.parseInt(colums[2]),
//                                    Integer.parseInt(colums[3]),
//                            Integer.parseInt(colums[4]),
//                            colums[5],
//                            colums[6],
//                            colums[7],
//                            colums[8],
//                            colums[9]
//                    );
//
//                    values.add(contents.getInsertValue());
//                    i++;
//                }
//
//                if(!values.isEmpty()) {
//                    String insertQuery = ReaderContract.ContentsTable.INSERT_QUERY + TextUtils.join(",", values);
//                    db.execSQL(insertQuery);
//                    values.clear();
//                }
//
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//        }
//    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int i, int i2) throws SQLiteException {


    }

}