/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.catcher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.parser.catcher.SmsMmsService;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;
import tenqube.parser.constants.Constants;
import tenqube.parser.model.SMS;

public class SMSCatcher
extends BroadcastReceiver {
    private String TAG = SMSCatcher.class.getSimpleName();
    private static final String SMS_RECEIVED_ACTION = "android.provider.Telephony.SMS_RECEIVED";

    public void onReceive(Context context, Intent intent) {
        try {
            SMS sms;
            if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
                return;
            }
            if (SMS_RECEIVED_ACTION.equals(intent.getAction()) && (sms = this.parseSms(intent.getExtras())) != null) {
                this.sendIntentService(context, sms);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SMS parseSms(Bundle bundle) {
        if (bundle != null) {
            String originMsg = "";
            String displayMsg = "";
            String originTel = "";
            String displayTel = "";
            long date = 0L;
            Object[] pdusObj = (Object[])bundle.get("pdus");
            if (pdusObj != null) {
                for (Object obj : pdusObj) {
                    SmsMessage currentMessage;
                    if (Build.VERSION.SDK_INT >= 23) {
                        String format = bundle.getString("format");
                        currentMessage = SmsMessage.createFromPdu((byte[])((byte[])obj), (String)format);
                    } else {
                        currentMessage = SmsMessage.createFromPdu((byte[])((byte[])obj));
                    }
                    if (currentMessage == null) continue;
                    if (currentMessage.getDisplayOriginatingAddress() != null) {
                        displayTel = currentMessage.getDisplayOriginatingAddress();
                    }
                    if (currentMessage.getOriginatingAddress() != null) {
                        originTel = currentMessage.getOriginatingAddress();
                    }
                    if (currentMessage.getTimestampMillis() != 0L) {
                        date = currentMessage.getTimestampMillis();
                    }
                    if (currentMessage.getMessageBody() != null) {
                        originMsg = originMsg + currentMessage.getMessageBody();
                    }
                    if (currentMessage.getDisplayMessageBody() == null) continue;
                    displayMsg = displayMsg + currentMessage.getDisplayMessageBody();
                }
                if (!(displayTel == null && originTel == null || TextUtils.isEmpty((CharSequence)displayTel) && TextUtils.isEmpty((CharSequence)originTel) || TextUtils.isEmpty((CharSequence)displayMsg) && TextUtils.isEmpty((CharSequence)originMsg))) {
                    String fullSms = this.selectMsg(originMsg, displayMsg);
                    return new SMS(0, fullSms, originTel, displayTel, Utils.getConvertedDate(date), Constants.SMSType.SMS.ordinal());
                }
            }
        }
        return null;
    }

    private void sendIntentService(Context context, SMS sms) {
        Intent startIntent = new Intent(context, SmsMmsService.class);
        startIntent.putExtra("ARG_SMS", (Serializable)sms);
        context.startService(startIntent);
    }

    private String selectMsg(String originMsg, String displayMsg) {
        if (TextUtils.isEmpty((CharSequence)originMsg)) {
            return displayMsg;
        }
        if (TextUtils.isEmpty((CharSequence)displayMsg)) {
            return originMsg;
        }
        String msg = originMsg.equals(displayMsg) ? originMsg : displayMsg;
        return msg;
    }
}

