/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api;

import android.content.Context;
import com.google.gson.Gson;
import com.tenqube.visual_third.api.VisualApiService;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.TransactionRequest;
import com.tenqube.visual_third.repository.VisualRepository;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import tenqube.parser.OnNetworkResultListener;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParsingRule;
import tenqube.parser.util.LogUtil;

public class VisualApi {
    public static final String TAG = VisualApi.class.getSimpleName();
    public static VisualApi mInstance;
    private Context context;
    private VisualApiService visualApiService;
    private PrefManager prefManager;
    private VisualRepository repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisualApi getInstance(Context context) {
        Class<VisualApi> clazz = VisualApi.class;
        synchronized (VisualApi.class) {
            if (mInstance == null) {
                mInstance = new VisualApi(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private VisualApi(Context context) {
        this.context = context;
        this.prefManager = PrefManager.getInstance(context);
        this.repository = VisualRepository.getInstance(context);
    }

    private VisualApiService getApiService() {
        if (this.visualApiService == null) {
            this.visualApiService = (VisualApiService)this.provideRetrofit(this.getUrl()).create(VisualApiService.class);
        }
        return this.visualApiService;
    }

    private String getUrl() {
        return "https://clip.tenqube.kr/" + this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev") + "/";
    }

    private Retrofit provideRetrofit(String url) {
        return new Retrofit.Builder().baseUrl(url).client(this.provideOkHttpClient()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new Gson())).build();
    }

    private OkHttpClient provideOkHttpClient() {
        OkHttpClient.Builder okhttpClientBuilder = new OkHttpClient.Builder();
        okhttpClientBuilder.connectTimeout(5L, TimeUnit.SECONDS);
        okhttpClientBuilder.readTimeout(5L, TimeUnit.SECONDS);
        okhttpClientBuilder.writeTimeout(5L, TimeUnit.SECONDS);
        return okhttpClientBuilder.build();
    }

    public SignUpResponse signUp(SignUpRequest signUpInfo) {
        try {
            String apiKey = this.prefManager.loadStringValue("TENQUBE_API_KEY", "");
            Response response = this.getApiService().signUp(apiKey, signUpInfo).execute();
            if (response.isSuccessful()) {
                return (SignUpResponse)response.body();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void syncCategory(int version) {
        try {
            String apiKey = this.prefManager.loadStringValue("TENQUBE_API_KEY", "");
            String authorization = this.prefManager.loadStringValue("TENQUBE_UID", "");
            Call<SyncCategoryResponse> call = this.getApiService().syncCategory(apiKey, authorization, version);
            call.enqueue((Callback)new Callback<SyncCategoryResponse>(){

                public void onResponse(Call<SyncCategoryResponse> call, Response<SyncCategoryResponse> response) {
                    SyncCategoryResponse categoryResponse;
                    if (response.isSuccessful() && (categoryResponse = (SyncCategoryResponse)response.body()) != null) {
                        VisualApi.this.prefManager.saveIntValue("TENQUBE_CATEGORY_VERSION", categoryResponse.getVersion());
                        if (!categoryResponse.getCategories().isEmpty()) {
                            VisualApi.this.repository.mergeCategory(categoryResponse.getCategories());
                        }
                    }
                }

                public void onFailure(Call<SyncCategoryResponse> call, Throwable t) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ParsingRule syncParsingRule(int version) {
        try {
            String apiKey = this.prefManager.loadStringValue("TENQUBE_API_KEY", "");
            String authorization = this.prefManager.loadStringValue("TENQUBE_UID", "");
            Response response = this.getApiService().syncParsingRule(apiKey, authorization, version).execute();
            if (response.isSuccessful()) {
                return (ParsingRule)response.body();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public SearchCompanyResponse searchCompany(SearchCompanyRequest searchCompanyRequest) {
        try {
            String apiKey = this.prefManager.loadStringValue("TENQUBE_SEARCH_API_KEY", "");
            String searchUrl = this.prefManager.loadStringValue("TENQUBE_SEARCH_URL", "");
            String authorization = this.prefManager.loadStringValue("TENQUBE_UID", "");
            Response response = this.getApiService().searchCompany(apiKey, authorization, searchUrl, searchCompanyRequest).execute();
            if (response.isSuccessful()) {
                this.repository.updateRetrySearch(searchCompanyRequest.getTransactions(), false);
                return (SearchCompanyResponse)response.body();
            }
            if (response.code() == 499 || response.code() == 500) {
                this.repository.updateRetrySearch(searchCompanyRequest.getTransactions(), true);
            }
            LogUtil.LOGI((String)TAG, (String)("searchCompany" + response.code() + "msg" + response.message()), (boolean)ParserService.mIsDebug);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void saveTransactions(TransactionRequest transactionRequest, Callback<Void> callback) {
        String apiKey = this.prefManager.loadStringValue("TENQUBE_API_KEY", "");
        String authorization = this.prefManager.loadStringValue("TENQUBE_UID", "");
        Call<Void> call = this.getApiService().saveTransactions(apiKey, authorization, transactionRequest);
        call.enqueue(callback);
    }

    public void syncTransactions(final OnNetworkResultListener callback) {
        final TransactionRequest transactionRequest = this.repository.loadNotSyncedTransactions();
        if (transactionRequest != null) {
            this.saveTransactions(transactionRequest, new Callback<Void>(){

                public void onResponse(Call<Void> call, Response<Void> response) {
                    LogUtil.LOGI((String)"saveTran", (String)("saveTransactions" + response.code() + "msg" + response.message()), (boolean)ParserService.mIsDebug);
                    if (response.isSuccessful() || response.code() == 400) {
                        VisualApi.this.repository.updateSyncedTransactions(transactionRequest);
                    }
                    if (callback != null) {
                        callback.onResult(true);
                    }
                }

                public void onFailure(Call<Void> call, Throwable t) {
                    LogUtil.LOGI((String)"saveTran", (String)"saveTransactions onFailure", (boolean)ParserService.mIsDebug);
                    if (callback != null) {
                        callback.onResult(false);
                    }
                }
            });
        } else {
            LogUtil.LOGI((String)"saveTran", (String)"saveTransactions transactionRequest is null", (boolean)ParserService.mIsDebug);
            if (callback != null) {
                callback.onResult(false);
            }
        }
    }
}

