/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.analysis;

import android.content.Context;
import com.tenqube.visual_third.analysis.AnalysisService;
import com.tenqube.visual_third.analysis.FactoryAnalysis;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;
import java.util.ArrayList;

public class AnalysisServiceImpl
implements AnalysisService {
    private final Context context;
    private final int[] CATEGORIES = new int[]{0, 1, 26, 46, 24, 56, 54, 82, 42, 22, 44, 64, 52, 32, 34, 36, 62, 66, 10, 84, 88};
    ArrayList<Analysis> results = new ArrayList();

    public AnalysisServiceImpl(Context context) {
        this.context = context;
    }

    @Override
    public ArrayList<Analysis> loadAnalysisList(final ArrayList<Transaction> transactions) {
        Thread[] threads = new Thread[this.CATEGORIES.length];
        for (int i = 0; i < this.CATEGORIES.length; ++i) {
            final int finalI = i;
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    ArrayList filteredTransactions = AnalysisServiceImpl.this.filterTransactions(finalI, transactions);
                    ArrayList<Analysis> analyses = FactoryAnalysis.create(AnalysisServiceImpl.this.context, AnalysisServiceImpl.this.CATEGORIES[finalI]).performAnalysis(filteredTransactions);
                    if (analyses != null) {
                        AnalysisServiceImpl.this.results.addAll(analyses);
                    }
                }
            });
            threads[i].start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.results;
    }

    private ArrayList<Transaction> filterTransactions(int categoryCode, ArrayList<Transaction> transactions) {
        return new ArrayList<Transaction>();
    }
}

