package com.tenqube.visual_third.analysis;

import android.content.Context;

import com.tenqube.visual_third.analysis.category.Alcohol;
import com.tenqube.visual_third.analysis.category.Beauty;
import com.tenqube.visual_third.analysis.category.Cafe;
import com.tenqube.visual_third.analysis.category.Culture;
import com.tenqube.visual_third.analysis.category.Education;
import com.tenqube.visual_third.analysis.category.FamilyEvent;
import com.tenqube.visual_third.analysis.category.Finance;
import com.tenqube.visual_third.analysis.category.Food;
import com.tenqube.visual_third.analysis.category.HealthCare;
import com.tenqube.visual_third.analysis.category.Leports;
import com.tenqube.visual_third.analysis.category.Livings;
import com.tenqube.visual_third.analysis.category.Mart;
import com.tenqube.visual_third.analysis.category.Online;
import com.tenqube.visual_third.analysis.category.Shopping;
import com.tenqube.visual_third.analysis.category.Transport;
import com.tenqube.visual_third.analysis.category.Travel;
import com.tenqube.visual_third.analysis.category.Uncate;
import com.tenqube.visual_third.analysis.category.Withdraw;
import com.tenqube.visual_third.analysis.category.WithdrawMoving;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;

import java.util.ArrayList;

public class AnalysisServiceImpl implements AnalysisService{

    private final Context context;

    private final int[] CATEGORIES = new int[] {
            Monthly.CODE,
            Weekly.CODE,
            Alcohol.CODE,
            Beauty.CODE,
            Cafe.CODE,
            Culture.CODE,
            Education.CODE,
            FamilyEvent.CODE,
            Finance.CODE,
            Food.CODE,
            HealthCare.CODE,
            Leports.CODE,
            Livings.CODE,
            Mart.CODE,
            Online.CODE,
            Shopping.CODE,
            Transport.CODE,
            Travel.CODE,
            Uncate.CODE,
            Withdraw.CODE,
            WithdrawMoving.CODE

    };

    ArrayList<Analysis> results = new ArrayList<>();


    public AnalysisServiceImpl(Context context) {
        this.context = context;
    }

    /**
     * thread start
     * 1. category 별 row 필터
     * 2. 분석 thread 각각 스타트
     * 3. join 을 통해 결과 병합
     * 4. 리턴
     * @param transactions 지난 3개월 로우 데이터
     * @return 분석된 데이터
     */
    @Override
    public ArrayList<Analysis> loadAnalysisList(final ArrayList<Transaction> transactions) {

        // 2. 분석 thread 각각 스타트
        Thread[] threads = new Thread[CATEGORIES.length];
        for(int i = 0 ; i < CATEGORIES.length ; i++) {

            final int finalI = i;
            threads[i] = new Thread(new Runnable() {
                @Override
                public void run() {
                    ArrayList<Transaction> filteredTransactions = filterTransactions(finalI, transactions);
                    ArrayList<Analysis> analyses = FactoryAnalysis.create(context, CATEGORIES[finalI]).performAnalysis(filteredTransactions);

                    if(analyses != null)
                        results.addAll(analyses);
                }
            });
            threads[i].start();
        }

        for(Thread thread : threads) {
            try {
                thread.join();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return results;

    }



    private ArrayList<Transaction> filterTransactions(int categoryCode, ArrayList<Transaction> transactions) {

        return new ArrayList<>();
    }

}
