package com.tenqube.visual_third.api;

import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.TransactionRequest;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Url;
import tenqube.parser.model.ParsingRule;

interface VisualApiService {

    String BASE_URL = "https://clip.tenqube.kr/";

    @POST("users/sign-up")
    Call<SignUpResponse> signUp(@Header("x-api-key") String apiKey, @Body SignUpRequest signUp);

    @GET("sync/category/{version}")
    Call<SyncCategoryResponse> syncCategory(@Header("x-api-key") String apiKey, @Header("Authorization") String authorization, @Path("version") int version);

    @GET("sync/parsing-rule/{version}")
    Call<ParsingRule> syncParsingRule(@Header("x-api-key") String apiKey, @Header("Authorization") String authorization, @Path("version") int version);

    @POST("transaction")
    Call<Void> saveTransactions(@Header("x-api-key") String apiKey, @Header("Authorization") String authorization, @Body TransactionRequest transactionRequest);

    @POST
    Call<SearchCompanyResponse> searchCompany(@Header("x-api-key") String apiKey, @Header("Authorization") String authorization, @Url String url, @Body SearchCompanyRequest searchCompanyRequest);

}
