/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db;

import android.content.Context;
import android.content.res.AssetManager;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.UserCategory;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class DatabaseHelper
extends SQLiteOpenHelper {
    private static DatabaseHelper mInstance = null;
    private static final String DATABASE_NAME = "visual.db";
    private static final int DATABASE_VERSION = 1;
    private static final String TAG = LogUtil.makeLogTag(DatabaseHelper.class);
    private Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseHelper getInstance(Context context) {
        Class<DatabaseHelper> clazz = DatabaseHelper.class;
        synchronized (DatabaseHelper.class) {
            if (mInstance == null) {
                mInstance = new DatabaseHelper(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private DatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, 1);
        this.mContext = context;
    }

    public void onCreate(SQLiteDatabase db) throws SQLiteException {
        db.execSQL(" CREATE TABLE IF NOT EXISTS  CARDS (cId INTEGER  PRIMARY KEY  AUTOINCREMENT  , cardName TEXT  NOT NULL  DEFAULT  'none'  , cardType INTEGER  NOT NULL  DEFAULT  0  , cardSubType INTEGER  NOT NULL  DEFAULT  0  , changeName TEXT  NOT NULL  DEFAULT  'none'  , changeType INTEGER  NOT NULL  DEFAULT  0  , changeSubType INTEGER  NOT NULL  DEFAULT  0  , billingDay INTEGER  NOT NULL  DEFAULT  1  , balance REAL  NOT NULL  DEFAULT  0  , cardMemo TEXT  NOT NULL  DEFAULT  'none'  , isCardExcept INTEGER  NOT NULL  DEFAULT  0  , isCardCustom INTEGER  NOT NULL  DEFAULT  0  , isCardDeleted INTEGER  NOT NULL  DEFAULT  0  ,  UNIQUE (cardName , cardType , cardSubType) ON CONFLICT REPLACE )");
        db.execSQL(" CREATE TABLE IF NOT EXISTS  USER_CATEGORIES  (ucId INTEGER  PRIMARY KEY  AUTOINCREMENT  , repCode INTEGER  NOT NULL  DEFAULT  0  , isCateExcept INTEGER  NOT NULL  DEFAULT  0  , isCateMain INTEGER  NOT NULL  DEFAULT  0  )");
        db.execSQL(" CREATE TABLE IF NOT EXISTS  CATEGORIES  (_id INTEGER  PRIMARY KEY  AUTOINCREMENT  , cateCode INTEGER  NOT NULL  DEFAULT  0  , largeName TEXT  NOT NULL  DEFAULT  'none'  , mediumName TEXT  NOT NULL  DEFAULT  'none'  , smallName TEXT  NOT NULL  DEFAULT  'none'  )");
        db.execSQL(" CREATE TABLE  TRANSACTIONS (tranId INTEGER  PRIMARY KEY  AUTOINCREMENT  , identifier REAL  NOT NULL  UNIQUE  , cardId INTEGER  NOT NULL  DEFAULT  0  , userCategoryId INTEGER  NOT NULL  DEFAULT  0  , companyId INTEGER  NOT NULL  DEFAULT  0  , franchise TEXT  NOT NULL  DEFAULT  'none'  , categoryCode INTEGER  NOT NULL  DEFAULT 101010 , spentDate DATETIME  NOT NULL  DEFAULT  0  , finishDate DATETIME  NOT NULL  DEFAULT  0  , spentLatitude REAL  NOT NULL  DEFAULT  0  , spentLongitude REAL  NOT NULL  DEFAULT  0  , spentMoney REAL  NOT NULL  DEFAULT  0  , installmentCount INTEGER  NOT NULL  DEFAULT 1 , keyword TEXT  NOT NULL  DEFAULT  'none'  , searchKeyword TEXT  NOT NULL  DEFAULT  'none'  , repeatType INTEGER  NOT NULL  DEFAULT  0  , currency TEXT  , isDeleted INTEGER  NOT NULL  DEFAULT  0  , dwType INTEGER  NOT NULL  DEFAULT  0  , sender TEXT  NOT NULL  DEFAULT  'none'  , fullSms TEXT  NOT NULL  DEFAULT  'none'  , smsDate DATETIME  NOT NULL  DEFAULT  0  , smsType INTEGER  NOT NULL  DEFAULT  0  , regId INTEGER  NOT NULL  DEFAULT  0  , isOffset INTEGER  NOT NULL  DEFAULT  0  , isCustom INTEGER  NOT NULL  DEFAULT  0  , isUserUpdate INTEGER  NOT NULL  DEFAULT  0  , isUpdateAll INTEGER  NOT NULL  DEFAULT  0  , memo TEXT  , classCode TEXT  NOT NULL  DEFAULT  'none'  , isSynced INTEGER  NOT NULL  DEFAULT  0  , shouldRetrySearch INTEGER  NOT NULL  DEFAULT  0 )");
        db.execSQL("CREATE INDEX visual_card_idx ON  CARDS (cardName,cardType,cardSubType)");
        db.execSQL("CREATE INDEX qlip_transaction_idx2 ON  TRANSACTIONS (spentDate,dwType)");
        this.insertCategories(db);
        this.insertUserCategories(db);
    }

    private void insertCategories(SQLiteDatabase db) throws SQLiteException {
        if (db != null) {
            ArrayList<String> values = new ArrayList<String>();
            AssetManager am = this.mContext.getAssets();
            int i = 0;
            try {
                String line;
                InputStream inStream = am.open("categories.tsv");
                BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
                while ((line = buffer.readLine()) != null) {
                    if (i == 0) {
                        ++i;
                        continue;
                    }
                    String[] colums = line.split("\t");
                    Category category = new Category(Integer.parseInt(colums[0]), Integer.parseInt(colums[1]), colums[2], colums[3], colums[4]);
                    values.add(category.getInsertValue());
                    ++i;
                }
                if (!values.isEmpty()) {
                    String insertQuery = "INSERT OR REPLACE INTO CATEGORIES (_id,cateCode,largeName,mediumName,smallName)VALUES" + TextUtils.join((CharSequence)",", values);
                    db.execSQL(insertQuery);
                    values.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void insertUserCategories(SQLiteDatabase db) throws SQLiteException {
        ArrayList<String> values = new ArrayList<String>();
        values.add(new UserCategory(1, 101010, false, false).getInsertValue());
        values.add(new UserCategory(2, 221010, false, false).getInsertValue());
        values.add(new UserCategory(3, 241010, false, false).getInsertValue());
        values.add(new UserCategory(4, 261010, false, false).getInsertValue());
        values.add(new UserCategory(5, 321010, false, false).getInsertValue());
        values.add(new UserCategory(6, 341010, false, false).getInsertValue());
        values.add(new UserCategory(7, 361010, false, false).getInsertValue());
        values.add(new UserCategory(8, 421010, false, false).getInsertValue());
        values.add(new UserCategory(9, 441010, false, false).getInsertValue());
        values.add(new UserCategory(10, 461010, false, false).getInsertValue());
        values.add(new UserCategory(11, 521010, false, false).getInsertValue());
        values.add(new UserCategory(12, 541010, false, false).getInsertValue());
        values.add(new UserCategory(13, 561010, false, false).getInsertValue());
        values.add(new UserCategory(14, 621010, false, false).getInsertValue());
        values.add(new UserCategory(15, 641010, false, false).getInsertValue());
        values.add(new UserCategory(16, 661010, false, false).getInsertValue());
        values.add(new UserCategory(17, 821010, false, false).getInsertValue());
        values.add(new UserCategory(18, 841010, false, false).getInsertValue());
        values.add(new UserCategory(19, 881010, true, false).getInsertValue());
        values.add(new UserCategory(20, 901010, false, false).getInsertValue());
        values.add(new UserCategory(21, 921010, false, false).getInsertValue());
        values.add(new UserCategory(22, 941010, false, false).getInsertValue());
        values.add(new UserCategory(23, 961010, false, false).getInsertValue());
        values.add(new UserCategory(24, 981010, true, false).getInsertValue());
        String insertQuery = "INSERT OR REPLACE INTO USER_CATEGORIES (ucId,repCode,isCateExcept,isCateMain)VALUES" + TextUtils.join((CharSequence)",", values);
        LogUtil.LOGI((String)TAG, (String)("insertUserCategories:" + insertQuery), (boolean)ParserService.mIsDebug);
        db.execSQL(insertQuery);
        values.clear();
    }

    public void onUpgrade(SQLiteDatabase db, int i, int i2) throws SQLiteException {
    }
}

