package com.tenqube.visual_third.util;

import android.content.Context;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.manager.PrefManager;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

import tenqube.parser.model.Transaction;

import static com.tenqube.visual_third.Constants.ALCOHOL;
import static com.tenqube.visual_third.Constants.BEAUTY;
import static com.tenqube.visual_third.Constants.CAFE;
import static com.tenqube.visual_third.Constants.CULTURE;
import static com.tenqube.visual_third.Constants.DEPOSIT_ETC;
import static com.tenqube.visual_third.Constants.DEPOSIT_LOAN;
import static com.tenqube.visual_third.Constants.DEPOSIT_MOVING_ASSET;
import static com.tenqube.visual_third.Constants.EDUCATION;
import static com.tenqube.visual_third.Constants.FAMILY_EVENT;
import static com.tenqube.visual_third.Constants.FINANCE;
import static com.tenqube.visual_third.Constants.FOOD;
import static com.tenqube.visual_third.Constants.FROM;
import static com.tenqube.visual_third.Constants.HEALTHCARE;
import static com.tenqube.visual_third.Constants.INCOME_MAIN;
import static com.tenqube.visual_third.Constants.INCOME_SUB;
import static com.tenqube.visual_third.Constants.LEPORTS;
import static com.tenqube.visual_third.Constants.LIVINGS;
import static com.tenqube.visual_third.Constants.MART;
import static com.tenqube.visual_third.Constants.ONLINE;
import static com.tenqube.visual_third.Constants.SHOPPING;
import static com.tenqube.visual_third.Constants.TO;
import static com.tenqube.visual_third.Constants.TRANSPORT;
import static com.tenqube.visual_third.Constants.TRAVEL;
import static com.tenqube.visual_third.Constants.UNCATE;
import static com.tenqube.visual_third.Constants.WITHDRAW_CODE;
import static com.tenqube.visual_third.Constants.WITHDRAW_MOVING_ASSET;
import static com.tenqube.visual_third.manager.PrefManager.ACCESS_NOTI_LISTENER;
import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class Utils {

    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");// decimalformat은
    private static final DecimalFormat THREE_COMMA_FORMAT = new DecimalFormat("###,###");

    public static  <T> T fromJson(String param, Class<T> classOfT) {
        Gson gson = new Gson();
        return gson.fromJson(param, classOfT);
    }

    public static String toJson(Object object) {
        Gson gson = new Gson();
        return gson.toJson(object);
    }

    public static boolean shouldParsing(String msg) {

        int cnt = 0;

        if(TextUtils.isEmpty(msg)) return false;

        if(msg.contains("원")) ++cnt;

        if(msg.contains(".")) ++cnt;

        if(msg.contains(",")) ++cnt;

        if(cnt == 3) return true;

        if(msg.contains("/")) ++cnt;

        return cnt > 2;
    }

    public static String getConvertedDate(long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        return getStringDateAsYYYYMMddHHmmss(cal);
    }


    public static String getStringDateAsYYYYMMddHHmmss(Calendar cal) {

        try {
            if (cal == null) cal = Calendar.getInstance();

            return cal.get(Calendar.YEAR) + "-" +
                    DECIMAL_FORMAT.format((cal.get(Calendar.MONTH) + 1)) + "-" +
                    DECIMAL_FORMAT.format(cal.get(Calendar.DATE)) + " " +
                    DECIMAL_FORMAT.format(cal.get(Calendar.HOUR_OF_DAY)) + ":" +
                    DECIMAL_FORMAT.format(cal.get(Calendar.MINUTE)) + ":" +
                    DECIMAL_FORMAT.format(cal.get(Calendar.SECOND));
        } catch (Exception e) {
            e.printStackTrace();
        }

        return "";
    }

    public static String threeComma(double value) {
        return THREE_COMMA_FORMAT.format((long) value) + "원";
    }

    public static String makeDialogPath(int tranId, String keyword, String lCategory, String mCategory, String lCode, String mCode, String spentDate, double amount, int installmentCnt, int cardId, String memo, String dwType, String prevPage) {
        return String.format(Locale.KOREA, "dialog/?id=%1$d&keyword=%2$s&lCategory=%3$s&mCategory=%4$s&lCode=%5$s&mCode=%6$s&date=%7$s&amount=%8$f&installmentCnt=%9$d&cardId=%10$d&memo=%11$s&dwType=%12$s&prevPage=%13$s",
                tranId, keyword, lCategory, mCategory, lCode, mCode, spentDate, amount, installmentCnt, cardId, memo, dwType, prevPage);
    }

    /**
     *  파라미터로 해당 년, 월의 데이터와 'before' 이전의 데이터의 기간을 설정합니다. 예를 들면 2018년 5월 부터 2018년 8월까지의 데이터를 호출하려면
     * @param year 해당 년
     * @param month 해당 월
     * @param before 개월수
     * @return
     */
    public static String[] getDateRange(int year, int month, int before) {

        String[] dates = new String[2];

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        calendar.add(Calendar.MONTH, before);
        dates[FROM] = "'" + calendar.get(Calendar.YEAR) + "-" + DECIMAL_FORMAT.format(calendar.get(Calendar.MONTH) + 1) + "-01 00:00:00'";

        calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        calendar.add(Calendar.MONTH, 1);
        dates[TO] = "'" + calendar.get(Calendar.YEAR) + "-" + DECIMAL_FORMAT.format(calendar.get(Calendar.MONTH) + 1) + "-01 00:00:00'";

        return dates;

    }


    public static int getCategoryIcon(int categoryCode) {

        switch (categoryCode) {
            case UNCATE:

                return R.drawable.ic_withdraw_etc;

            case FOOD:

                return R.drawable.ic_withdraw_food;

            case CAFE:

                return R.drawable.ic_withdraw_cafe;

            case ALCOHOL:

                return R.drawable.ic_withdraw_alcohol;

            case MART:

                return R.drawable.ic_withdraw_mart;

            case ONLINE:

                return R.drawable.ic_withdraw_online;

            case SHOPPING:

                return R.drawable.ic_withdraw_shopping;

            case FINANCE:

                return R.drawable.ic_withdraw_finance;

            case HEALTHCARE:

                return R.drawable.ic_withdraw_health_care;

            case BEAUTY:

                return R.drawable.ic_withdraw_beauty;

            case LIVINGS:

                return R.drawable.ic_withdraw_livings;

            case EDUCATION:

                return R.drawable.ic_withdraw_education;

            case CULTURE:

                return R.drawable.ic_withdraw_culture;

            case TRANSPORT:

                return R.drawable.ic_withdraw_transport;

            case LEPORTS:

                return R.drawable.ic_withdraw_leports;

            case TRAVEL:

                return R.drawable.ic_withdraw_travel;

            case FAMILY_EVENT:

                return R.drawable.ic_withdraw_family_event;

            case WITHDRAW_CODE:

                return R.drawable.ic_withdraw;

            case WITHDRAW_MOVING_ASSET:

                return R.drawable.ic_withdraw_moving_asset;

            case DEPOSIT_ETC:

                return R.drawable.ic_deposit_etc;

            case INCOME_MAIN:

                return R.drawable.ic_deposit_income_main;

            case INCOME_SUB:

                return R.drawable.ic_deposit_income_sub;

            case DEPOSIT_LOAN:

                return R.drawable.ic_deposit_loan;

            case DEPOSIT_MOVING_ASSET:

                return R.drawable.ic_deposit_moving_asset;

            default:

                return 0;

        }
    }

    public static void print(String title, ArrayList<Transaction> list) {

        for(Object object : list) {
            LOGI("PRINT", "title:" + title + "\n" + "object: " + object.toString(), mIsDebug);

        }
    }

    public static boolean isNotiEnabled(Context context) {
        return  NotificationManagerCompat.getEnabledListenerPackages(context).contains(context.getPackageName()) ||
                PrefManager.getInstance(context).isEnabled(ACCESS_NOTI_LISTENER, false);
    }

}
