package com.tenqube.visual_third.model.api;

import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * {
 "identifier": "1243",
 "spentMoney": 16291000
 }
 */
public class TransactionRequest implements Serializable {

    private ArrayList<Transaction> transactions;

    public ArrayList<Transaction> getTransactions() {
        return transactions;
    }

    public TransactionRequest(ArrayList<Transaction> transactions) {
        this.transactions = transactions;
    }

    public static class Transaction implements Serializable  {
        private String identifier;
        private String cardName;
        private String cardNum;
        private int cardType;
        private int cardSubType;
        private double spentMoney;
        private double oriSpentMoney;
        private String spentDate;
        private String finishDate;
        private String oriKeyword;
        private String searchKeyword;
        private int installmentCount;
        private int dwType;
        private String currency;
        private double balance;
        private String sender;
        private String fullSms;
        private String smsDate;
        private int smsType;
        private int isOffset;
        private int isDuplicate;
        private String memo;
        private double spentLatitude;
        private double spentLongitude;
        private int categoryCode;
        private int companyId;
        private String classCode;
        private int regId;

        public Transaction(JoinedTransaction transaction) throws ParameterException {
            this.identifier = transaction.getTransaction().getIdentifier() + "";
            this.cardName = transaction.getCard().getName();
            this.cardType = transaction.getCard().getType();
            this.cardSubType = transaction.getCard().getSubType();
            this.spentMoney = transaction.getTransaction().getSpentMoney();
            this.oriSpentMoney = transaction.getTransaction().getSpentMoney();
            this.spentDate = transaction.getTransaction().getSpentDate();
            this.finishDate = transaction.getTransaction().getFinishDate();
            this.oriKeyword = transaction.getTransaction().getKeyword();
            this.searchKeyword = transaction.getTransaction().getSearchKeyword();
            this.installmentCount = transaction.getTransaction().getInstallmentCnt();
            this.dwType = transaction.getTransaction().getDwType();
            this.currency = transaction.getTransaction().getCurrency();
            this.balance = transaction.getCard().getBalance();
            this.sender = transaction.getTransaction().getSender();
            this.fullSms = transaction.getTransaction().getFullSms();
            this.smsDate = transaction.getTransaction().getSmsDate();
            this.smsType = transaction.getTransaction().getSmsType();
            this.isOffset = transaction.getTransaction().isOffset() ? 1 : 0;
            this.memo = transaction.getTransaction().getMemo();
            this.spentLatitude = transaction.getTransaction().getLat();
            this.spentLongitude = transaction.getTransaction().getLng();
            this.categoryCode = transaction.getTransaction().getCategoryCode();
            this.companyId = transaction.getTransaction().getCompanyId();
            this.classCode = transaction.getTransaction().getClassCode();
            this.regId = transaction.getTransaction().getRegId();
        }

        public Transaction(String identifier,
                           String cardName,
                           String cardNum,
                           int cardType,
                           int cardSubType,
                           double spentMoney,
                           double oriSpentMoney,
                           String spentDate,
                           String finishDate,
                           String oriKeyword,
                           String searchKeyword,
                           int installmentCount,
                           int dwType,
                           String currency,
                           double balance,
                           String sender,
                           String fullSms,
                           String smsDate,
                           int smsType,
                           int isOffset,
                           int isDuplicate,
                           String memo,
                           double spentLatitude,
                           double spentLongitude,
                           int categoryCode,
                           int companyId,
                           String classCode,
                           int regId)
                throws ParameterException {

            this.identifier = identifier;
            this.cardName = cardName;
            this.cardNum = cardNum;
            this.cardType = cardType;
            this.cardSubType = cardSubType;
            this.spentMoney = spentMoney;
            this.oriSpentMoney = oriSpentMoney;
            this.spentDate = spentDate;
            this.finishDate = finishDate;
            this.oriKeyword = oriKeyword;
            this.searchKeyword = searchKeyword;
            this.installmentCount = installmentCount;
            this.dwType = dwType;
            this.currency = currency;
            this.balance = balance;
            this.sender = sender;
            this.fullSms = fullSms;
            this.smsDate = smsDate;
            this.smsType = smsType;
            this.isOffset = isOffset;
            this.isDuplicate = isDuplicate;
            this.memo = memo;
            this.spentLatitude = spentLatitude;
            this.spentLongitude = spentLongitude;
            this.categoryCode = categoryCode;
            this.companyId = companyId;
            this.classCode = classCode;
            this.regId = regId;
        }

        public String getIdentifier() {
            return identifier;
        }
    }



}
