package com.tenqube.visual_third.parser.loader

import android.content.Context
import com.tenqube.notiparser.domain.dto.SMSRequest
import com.tenqube.notiparser.domain.dto.SMSResponse
import com.tenqube.notiparser.presentation.Layer
import com.tenqube.notiparser.presentation.SmsArg
import com.tenqube.notiparser.presentation.SmsService
import com.tenqube.notiparser.presentation.SmsServiceBuilder
import com.tenqube.visual_third.manager.PrefManager
import kotlinx.coroutines.runBlocking
import timber.log.Timber

object SmsManager {

    private var smsService: SmsService? = null

    fun parsing(context: Context, smsRequest: SMSRequest): SMSResponse? = runBlocking {

        return@runBlocking try {
            createSmsService(context)
            smsService?.parse(smsRequest).also {
                Timber.i("$it")
            }
        } catch (e: Exception) {
            null
        }
    }

    private fun createSmsService(context: Context) {
        if(smsService == null) {
            smsService = SmsServiceBuilder()
                    .with(context)
                    .arg(SmsArg(Layer.PROD, PrefManager.getInstance(context).loadStringValue(PrefManager.CUST_ID, ""), "clip"))
                    .build()
        }
    }
}