/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Toast;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.model.js.Cards;
import com.tenqube.visual_third.model.js.CategoryInfo;
import com.tenqube.visual_third.model.js.ConfirmBoxRequest;
import com.tenqube.visual_third.model.js.Lv0Info;
import com.tenqube.visual_third.model.js.NewViewInfo;
import com.tenqube.visual_third.model.js.SelectBoxInfo;
import com.tenqube.visual_third.model.js.SelectBoxRequest;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.model.js.Transactions;
import com.tenqube.visual_third.model.js.UpdateTransactionRequest;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.GoOpenMarketUtil;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;

class WebAppInterface
implements BottomDialog.OnBottomListener {
    private final Activity activity;
    private final WebView webView;
    private final VisualRepository repository;
    private final VisualApi api;
    private String callbackSelectOrderBy;
    private String callbackNoti;
    private BottomDialog bottomDialog;
    AlertDialog notiDialog;

    WebAppInterface(Activity activity, WebView webView, BottomDialog bottomDialog, VisualRepository repository, VisualApi api) {
        this.activity = activity;
        this.webView = webView;
        this.bottomDialog = bottomDialog;
        this.bottomDialog.setBottomListener(this);
        this.repository = repository;
        this.api = api;
    }

    @JavascriptInterface
    public void openConfirmBox(String params) {
        try {
            final ConfirmBoxRequest confirmBoxRequest = Utils.fromJson(params, ConfirmBoxRequest.class);
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
            builder.setMessage((CharSequence)confirmBoxRequest.getMessage());
            builder.setNegativeButton((CharSequence)confirmBoxRequest.getData().get(0).getButtonText(), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    WebAppInterface.this.callback(confirmBoxRequest.getData().get(0).getCallbackJS(), null);
                }
            });
            builder.setPositiveButton((CharSequence)confirmBoxRequest.getData().get(1).getButtonText(), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    WebAppInterface.this.callback(confirmBoxRequest.getData().get(1).getCallbackJS(), null);
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void openSelectBox(String params) {
        try {
            SelectBoxRequest selectBoxRequest = Utils.fromJson(params, SelectBoxRequest.class);
            this.callbackSelectOrderBy = selectBoxRequest.getDataCallbackJS();
            if (this.bottomDialog != null) {
                this.bottomDialog.showBottomDialog(selectBoxRequest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onItemSelected(SelectBoxInfo selectBoxInfo) {
        this.bottomDialog.dismiss();
        this.callback(this.callbackSelectOrderBy, selectBoxInfo);
    }

    @JavascriptInterface
    public void openNewView(String params) {
        try {
            NewViewInfo newViewInfo = Utils.fromJson(params, NewViewInfo.class);
            if (newViewInfo == null) {
                return;
            }
            if ("external".equals(newViewInfo.getViewType())) {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(Uri.parse((String)newViewInfo.getUrl()));
                this.activity.startActivity(i);
            } else if ("internal".equals(newViewInfo.getViewType())) {
                VisualWebActivity.startActivityForResult(this.activity, newViewInfo.getUrl());
            } else if ("google".equals(newViewInfo.getViewType())) {
                GoOpenMarketUtil.openOnGooglePlayMarket((Context)this.activity, newViewInfo.getUrl());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void finish(String path) {
        try {
            if (this.activity != null) {
                if (!TextUtils.isEmpty((CharSequence)path)) {
                    Intent intent = this.activity.getIntent();
                    intent.putExtra("path", path);
                    this.activity.setResult(-1, intent);
                }
                this.activity.finish();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void getCategories(final String callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<CategoryInfo.ServerCategory> serverCategories = WebAppInterface.this.repository.loadCategories();
                    ArrayList<CategoryInfo.UserCategory> userCategories = WebAppInterface.this.repository.loadUserCategories();
                    CategoryInfo categoryInfo = new CategoryInfo(serverCategories, userCategories);
                    WebAppInterface.this.callback(callback, categoryInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @JavascriptInterface
    public void getCards(final String callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<Cards.Card> cardList = WebAppInterface.this.repository.loadCards();
                    Cards cards = new Cards(cardList);
                    WebAppInterface.this.callback(callback, cards);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @JavascriptInterface
    public void getTransactions(final String params) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionRequest transactionRequest = Utils.fromJson(params, TransactionRequest.class);
                    ArrayList<Transactions.Transaction> tranList = WebAppInterface.this.repository.loadTransactions(transactionRequest);
                    Transactions transactions = new Transactions(tranList);
                    WebAppInterface.this.callback(transactionRequest.getCallbackJS(), transactions);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @JavascriptInterface
    public void getLv0Contents(final String callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<Lv0Info.Lv0> lv0s = new ArrayList<Lv0Info.Lv0>();
                    lv0s.add(new Lv0Info.Lv0("lv0_mid_beauty_nail", "\ubdf0\ud2f0/\ubbf8\uc6a9", "\ub124\uc77c \ucf00\uc5b4  \ubc1b\uc740 \uc9c0 15\uc77c \ub418\uc5c8\uc2b5\ub2c8\ub2e4.", "\ub9c8\uc9c0\ub9c9\uc73c\ub85c \ucf00\uc5b4 \ubc1b\uc740 \ub0a0\uc740\n%s (%s) \uc785\ub2c8\ub2e4.  \n\n\uc9c0\ub09c 3\uac1c\uc6d4\uac04 \ub124\uc77c\ucf00\uc5b4\ub97c \ucd1d %s\ubc88 \ubc1b\uc558\uc2b5\ub2c8\ub2e4."));
                    lv0s.add(new Lv0Info.Lv0("lv0_mid_culture_movies", "\ubb38\ud654/\uc608\uc220", "\uc601\ud654 \ubcf8 \uc9c0 15\uc77c \uc9c0\ub0ac\uc2b5\ub2c8\ub2e4.", "\ub9c8\uc9c0\ub9c9\uc73c\ub85c \uc601\ud654 \ubcf8 \ub0a0\uc740\n%s (%s) \uc785\ub2c8\ub2e4.  \n\n\uc9c0\ub09c 3\uac1c\uc6d4, \uc601\ud654\ub97c %s\ubc88 \ubd24\uc2b5\ub2c8\ub2e4. "));
                    Lv0Info lv0Info = new Lv0Info(lv0s);
                    WebAppInterface.this.callback(callback, lv0Info);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @JavascriptInterface
    public void updateTransaction(final String params) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    UpdateTransactionRequest updateTransactionRequest = null;
                    try {
                        updateTransactionRequest = Utils.fromJson(params, UpdateTransactionRequest.class);
                        WebAppInterface.this.repository.updateTransaction(updateTransactionRequest);
                        WebAppInterface.this.api.syncTransactions(null);
                        WebAppInterface.this.callback(updateTransactionRequest.getCallbackJS(), "success");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (updateTransactionRequest == null) break block2;
                        WebAppInterface.this.callback(updateTransactionRequest.getCallbackJS(), "fail");
                    }
                }
            }
        }).start();
    }

    public void callback(final String callback, final Object object) {
        try {
            this.webView.post(new Runnable(){

                @Override
                public void run() {
                    WebAppInterface.this.webView.loadUrl(WebAppInterface.this.getJs(callback, object == null ? "" : Utils.toJson(object)));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onNotiCallback(final String json) {
        try {
            this.webView.post(new Runnable(){

                @Override
                public void run() {
                    WebAppInterface.this.webView.loadUrl(WebAppInterface.this.getJs(WebAppInterface.this.callbackNoti, json));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void showSnackBar(String msg) {
        try {
            Snackbar.make((View)this.webView, (CharSequence)msg, (int)-1).show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void showToast(String msg) {
        try {
            Toast.makeText((Context)this.activity, (CharSequence)msg, (int)0).show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void startNotiListener(String callback) {
        try {
            this.callbackNoti = callback;
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
            builder.setTitle((CharSequence)"\uc9c0\uae08\ubd80\ud130 \uc54c\ub9bc\uc744 \uac00\uacc4\ubd80\uc5d0 \uae30\ub85d\ud569\ub2c8\ub2e4.");
            builder.setPositiveButton((CharSequence)"\ub2e4\uc74c", new DialogInterface.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClick(DialogInterface dialog, int which) {
                    try {
                        Intent intent = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
                        WebAppInterface.this.activity.startActivityForResult(intent, 0);
                    }
                    catch (ActivityNotFoundException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (WebAppInterface.this.notiDialog != null) {
                            WebAppInterface.this.notiDialog.dismiss();
                        }
                    }
                }
            });
            this.notiDialog = builder.create();
            this.notiDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public boolean isNotiEnabled() {
        try {
            return Utils.isNotiEnabled(this.activity.getApplicationContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @JavascriptInterface
    public boolean isNetworkConnected() {
        try {
            ConnectivityManager cm = (ConnectivityManager)this.activity.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            return isConnected;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private String getJs(String callback, String data) {
        if (!TextUtils.isEmpty((CharSequence)data)) {
            data = "'" + data + "'";
        }
        return "javascript:window." + callback + "(" + data + ");";
    }
}

