package com.tenqube.visual_third.manager;

import com.tenqube.visual_third.model.js.Lv0Info;

import java.util.ArrayList;
import java.util.Random;

public class Lv0DataCache {

    public static final String TAG = Lv0DataCache.class.getSimpleName();

    public ArrayList<Lv0Info.Lv0> lv0s;

    private static Lv0DataCache mInstance = null;

    public static Lv0DataCache getInstance() {

        synchronized (Lv0DataCache.class) {
            if (mInstance == null) {
                mInstance = new Lv0DataCache();
            }
        }
        return mInstance;
    }

    private Lv0DataCache() {

    }

    public Lv0Info.Lv0 getLv0(String lcate) {

        ArrayList<Lv0Info.Lv0> targetItems = new ArrayList<>();

        for(Lv0Info.Lv0 lv0 : lv0s) {

            if(lcate.equals(lv0.getLabel())) {
                targetItems.add(lv0);
            }
        }

        if(!targetItems.isEmpty()) {
            return targetItems.get(new Random().nextInt(targetItems.size()));
        } else {
            return lv0s.get(new Random().nextInt(lv0s.size()));
        }

    }



}

