/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.sms.presentation;

import android.content.Context;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.sms.Injection;
import com.tenqube.visual_third.sms.data.api.NotiParserApi;
import com.tenqube.visual_third.sms.data.api.RuleService;
import com.tenqube.visual_third.sms.data.api.RuleServiceImpl;
import com.tenqube.visual_third.sms.data.db.SmsDatabase;
import com.tenqube.visual_third.sms.data.db.dao.SmsDao;
import com.tenqube.visual_third.sms.data.db.dao.SmsRuleDao;
import com.tenqube.visual_third.sms.domain.sms.DeleteAllSmsUseCase;
import com.tenqube.visual_third.sms.domain.sms.SmsRepository;
import com.tenqube.visual_third.sms.domain.smsrule.ParseSMSByRuleUseCase;
import com.tenqube.visual_third.sms.domain.smsrule.SmsRuleRepository;
import com.tenqube.visual_third.sms.presentation.SmsService;
import com.tenqube.visual_third.sms.presentation.SmsServiceImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.Retrofit;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/tenqube/visual_third/sms/presentation/SmsServiceBuilder;", "", "()V", "context", "Landroid/content/Context;", "ruleService", "Lcom/tenqube/visual_third/sms/data/api/RuleService;", "build", "Lcom/tenqube/visual_third/sms/presentation/SmsService;", "with", "app_release"})
public final class SmsServiceBuilder {
    private Context context;
    private RuleService ruleService;

    @NotNull
    public final SmsServiceBuilder with(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SmsServiceBuilder smsServiceBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        SmsServiceBuilder $this$apply = smsServiceBuilder;
        boolean bl3 = false;
        $this$apply.context = context;
        return smsServiceBuilder;
    }

    @NotNull
    public final SmsService build() {
        PrefManager prefManager;
        Context context = this.context;
        boolean bl = false;
        boolean bl2 = false;
        if (context == null) {
            boolean bl3 = false;
            throw (Throwable)new Exception("context is null");
        }
        PrefManager prefManager2 = prefManager = PrefManager.getInstance(this.context);
        Intrinsics.checkExpressionValueIsNotNull((Object)prefManager2, (String)"prefManager");
        OkHttpClient okHttpClient = Injection.INSTANCE.provideOkHttpClient(prefManager2);
        Retrofit retrofit = Injection.INSTANCE.provideRetrofit(okHttpClient);
        NotiParserApi notiParserApi = Injection.INSTANCE.provideNotiParserApi(retrofit);
        this.ruleService = new RuleServiceImpl(notiParserApi, prefManager, null, 4, null);
        Context context2 = this.context;
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        SmsDatabase db = Injection.INSTANCE.provideDb(context2);
        SmsDao smsDao = Injection.INSTANCE.provideSmsDao(db);
        SmsRuleDao smsRuleDao = Injection.INSTANCE.provideSmsRuleDao(db);
        SmsRepository smsRepository = Injection.INSTANCE.provideSmsRepository(smsDao);
        Context context3 = this.context;
        if (context3 == null) {
            Intrinsics.throwNpe();
        }
        RuleService ruleService = this.ruleService;
        if (ruleService == null) {
            Intrinsics.throwNpe();
        }
        SmsRuleRepository smsRuleRepository = Injection.INSTANCE.provideSmsRuleRepository(context3, smsRuleDao, ruleService, prefManager);
        ParseSMSByRuleUseCase parseSMSByRuleUseCase = Injection.INSTANCE.provideParseSMSByRuleUseCase(smsRuleRepository, smsRepository);
        DeleteAllSmsUseCase deleteAllSmsUseCase = Injection.INSTANCE.provideDeleteAllSmsUseCase(smsRepository);
        return new SmsServiceImpl(parseSMSByRuleUseCase, deleteAllSmsUseCase);
    }
}

