/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.sms.domain.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tenqube.visual_third.sms.domain.dto.SMSResponse;
import com.tenqube.visual_third.sms.domain.sms.Sms;
import com.tenqube.visual_third.sms.domain.smsrule.SmsRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a8\u0006\u0015"}, d2={"Lcom/tenqube/visual_third/sms/domain/utils/RegUtil;", "", "()V", "getMatcher", "", "pos", "", "matcher", "Ljava/util/regex/Matcher;", "getParsedDataFromRule", "rule", "isZeroOrPositiveInteger", "", "str", "matchByRules", "Lcom/tenqube/visual_third/sms/domain/dto/SMSResponse;", "sms", "Lcom/tenqube/visual_third/sms/domain/sms/Sms;", "rules", "", "Lcom/tenqube/visual_third/sms/domain/smsrule/SmsRule;", "app_release"})
public final class RegUtil {
    public static final RegUtil INSTANCE;

    @Nullable
    public final SMSResponse matchByRules(@NotNull Sms sms, @NotNull List<SmsRule> rules) {
        Intrinsics.checkParameterIsNotNull((Object)sms, (String)"sms");
        Intrinsics.checkParameterIsNotNull(rules, (String)"rules");
        for (SmsRule rule : rules) {
            Matcher matcher;
            Pattern p1;
            if (!StringsKt.contains$default((CharSequence)rule.getTitle(), (CharSequence)sms.getTitle(), (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)sms.getTitle(), (CharSequence)rule.getTitle(), (boolean)false, (int)2, null)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)Pattern.compile(rule.getRegExp(), 106), (String)"Pattern.compile(\n       \u2026DE_CASE\n                )");
            Intrinsics.checkExpressionValueIsNotNull((Object)p1.matcher(sms.getMsg()), (String)"p1.matcher(sms.msg)");
            if (!matcher.matches()) continue;
            Iterator iterator = rule.getBody().keySet().iterator();
            boolean bl = false;
            List keys = new ArrayList();
            while (iterator.hasNext()) {
                String key = ((String)iterator.next()).toString();
                JsonElement jsonElement = rule.getBody().get(key);
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"rule.body.get(key)");
                String value = jsonElement.getAsString();
                keys.add(new Pair((Object)key, (Object)value));
            }
            JsonObject resultJson = new JsonObject();
            Iterable $this$forEach$iv = keys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl2 = false;
                resultJson.addProperty((String)it.getFirst(), INSTANCE.getParsedDataFromRule((String)it.getSecond(), matcher));
            }
            return new SMSResponse(rule.getId(), sms.getDate(), resultJson);
        }
        return null;
    }

    private final String getParsedDataFromRule(String rule, Matcher matcher) {
        List parsedRule = StringsKt.split$default((CharSequence)rule, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        StringBuffer parsedData = new StringBuffer();
        Iterable $this$forEach$iv = parsedRule;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String str = (String)element$iv;
            boolean bl = false;
            boolean bl2 = INSTANCE.isZeroOrPositiveInteger(str);
            if (bl2) {
                int pos = Integer.parseInt(str);
                String data = INSTANCE.getMatcher(pos, matcher);
                parsedData.append(data);
                continue;
            }
            if (bl2) continue;
            parsedData.append(str);
        }
        String string2 = parsedData.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"parsedData.toString()");
        return string2;
    }

    private final boolean isZeroOrPositiveInteger(String str) {
        boolean bl;
        if (str == null) {
            return false;
        }
        CharSequence charSequence = str;
        int n = 0;
        if (charSequence.length() == 0) {
            return false;
        }
        if (str.charAt(0) == '0' && str.length() != 1) {
            return false;
        }
        String string2 = str;
        int n2 = string2.length();
        for (n = 0; n < n2; ++n) {
            char c = string2.charAt(n);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        try {
            Integer.parseInt(str);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private final String getMatcher(int pos, Matcher matcher) {
        String string2;
        try {
            String string3 = matcher.group(pos);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"matcher.group(pos)");
            string2 = string3;
            boolean bl = false;
            String string4 = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            if (string5 == null) {
                string5 = "";
            }
            string2 = string5;
        }
        catch (Exception e) {
            string2 = "";
        }
        return string2;
    }

    private RegUtil() {
    }

    static {
        RegUtil regUtil;
        INSTANCE = regUtil = new RegUtil();
    }
}

