/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Card;
import java.util.ArrayList;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class CardDao {
    private final Db db;

    public CardDao(Db db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll() {
        LogUtil.LOGI((String)"LOADALL", (String)"card loadAll", (boolean)ParserService.mIsDebug);
        String query = QueryGenerator.card();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    LogUtil.LOGI((String)"LOADALL", (String)ReaderContract.CardTable.populateModel(c).toString(), (boolean)ParserService.mIsDebug);
                    c.moveToNext();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Card> loadCards() {
        String query = QueryGenerator.card();
        ArrayList<Card> results = new ArrayList<Card>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    results.add(ReaderContract.CardTable.populateModel(c));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Card getCard(String cardName, int cardType, int cardSubType) {
        String query = QueryGenerator.cardId(cardName, cardType, cardSubType);
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst() && !c.isAfterLast()) {
                Card card = ReaderContract.CardTable.populateModel(c);
                return card;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCardId(String cardName, int cardType, int cardSubType) {
        String query = QueryGenerator.cardId(cardName, cardType, cardSubType);
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst() && !c.isAfterLast()) {
                int n = c.getInt(c.getColumnIndex("cId"));
                return n;
            }
        }
        return -1;
    }

    public int insert(String cardName, int cardType, int cardSubType) {
        try {
            ContentValues values = new ContentValues();
            values.put("cardName", cardName);
            values.put("cardType", Integer.valueOf(cardType));
            values.put("cardSubType", Integer.valueOf(cardSubType));
            values.put("changeName", cardName);
            values.put("changeType", Integer.valueOf(cardType));
            values.put("changeSubType", Integer.valueOf(cardSubType));
            return (int)this.db.insert(" CARDS", values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int insertCash() {
        try {
            return (int)this.db.insert(" CARDS", ReaderContract.CardTable.populateData());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void deleteAll() {
        try {
            this.db.delete(" CARDS", null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

