package com.tenqube.visual_third.sms.presentation

import com.tenqube.visual_third.sms.domain.dto.SMSRequest
import com.tenqube.visual_third.sms.domain.dto.SMSResponse
import com.tenqube.visual_third.sms.domain.sms.DeleteAllSmsUseCase
import com.tenqube.visual_third.sms.domain.smsrule.ParseSMSByRuleUseCase
import com.tenqube.visual_third.sms.domain.utils.getValue

class SmsServiceImpl(private val parseSMSUseCase: ParseSMSByRuleUseCase,
                     private val deleteAllSmsUseCase: DeleteAllSmsUseCase) : SmsService {

    override suspend fun parse(sms: SMSRequest): SMSResponse? {
        return try {
            parseSMSUseCase(sms).getValue()
        } catch (e: Exception) {
            null
        }
    }

    override suspend fun initialize() {
        deleteAllSmsUseCase()
    }

}