package com.tenqube.visual_third.sms.domain.utils

import com.google.gson.JsonObject
import com.tenqube.visual_third.sms.domain.dto.SMSResponse
import com.tenqube.visual_third.sms.domain.sms.Sms
import com.tenqube.visual_third.sms.domain.smsrule.SmsRule
import java.util.regex.Matcher
import java.util.regex.Pattern

object RegUtil {

    fun matchByRules(sms: Sms, rules: List<SmsRule>): SMSResponse? {

        for (rule in rules) {

            if(rule.title.contains(sms.title) || sms.title.contains(rule.title)) {
                val p1: Pattern = Pattern.compile(
                        rule.regExp,
                        Pattern.CASE_INSENSITIVE or Pattern.DOTALL or Pattern.MULTILINE or Pattern.UNICODE_CASE
                )

                val matcher: Matcher = p1.matcher(sms.msg)

                if (matcher.matches()) {
                    val iterator = rule.body.keySet().iterator()
                    val keys = mutableListOf<Pair<String, String>>()
                    while(iterator.hasNext()) {
                        val key  = iterator.next().toString()
                        val value = rule.body.get(key).asString
                        keys.add(Pair(key, value))
                    }

                    val resultJson = JsonObject()
                    keys.forEach {
                        resultJson.addProperty(it.first, getParsedDataFromRule(it.second, matcher))
                    }
                    return SMSResponse(id = rule.id, date = sms.date, body = resultJson)
                }
            }

        }
        return null
    }

    private fun getParsedDataFromRule(rule: String, matcher: Matcher): String {
        val parsedRule = rule.split(",")
        val parsedData = StringBuffer()

        parsedRule.forEach { str ->
            // str 이 숫자면 숫자에 해당하는 포지션 데이터 가져와서 append
            // str 이 숫자가 아니면 해당 문자열 append
            when (isZeroOrPositiveInteger(str)) {
                true -> {
                    val pos = Integer.parseInt(str)
                    val data = getMatcher(pos, matcher)
                    parsedData.append(data)
                }
                false -> parsedData.append(str)
            }
        }

        return parsedData.toString()
    }

    private  fun isZeroOrPositiveInteger(str: String?): Boolean {
        if (str == null) {
            return false
        }

        if (str.isEmpty()) {
            return false
        }

        if (str[0] == '0' && str.length != 1) {
            return false
        }

        for (c in str) {
            if (c < '0' || c > '9') {
                return false
            }
        }

        return try {
            Integer.parseInt(str)
            true

        } catch (e: Exception) {
            false
        }

    }

    private fun getMatcher(pos: Int, matcher: Matcher): String {
        return try {
            matcher.group(pos).trim() ?: ""
        } catch (e: Exception) {
            ""
        }
    }

}