package com.tenqube.visual_third.sms.domain.smsrule

import com.tenqube.visual_third.sms.domain.utils.Result
import com.tenqube.visual_third.sms.domain.dto.SMSRequest
import com.tenqube.visual_third.sms.domain.dto.SMSResponse
import com.tenqube.visual_third.sms.domain.mapper.DomainMapper
import com.tenqube.visual_third.sms.domain.sms.SmsRepository
import com.tenqube.visual_third.sms.domain.utils.RegUtil
import com.tenqube.visual_third.sms.domain.utils.getValue
import java.lang.Exception

class ParseSMSByRuleUseCase(private val smsRuleRepository: SmsRuleRepository,
                            private val smsRepository: SmsRepository) {

    suspend operator fun invoke(smsRequest: SMSRequest): Result<SMSResponse?> {

        return try {

            if(smsRuleRepository.isActive()) { // 활성화 상태에서만 파싱이 가능합니다.
                val sms = DomainMapper.toEntity(smsRequest)

                if(!smsRepository.isExist(sms).getValue()) {
                    val rules = smsRuleRepository.findBySender(sms.sender).getValue()
                    if(rules.isEmpty()) {
                        Result.Success(null)
                    } else {
                        val jsonObject = RegUtil.matchByRules(sms, rules)

                        if(jsonObject != null) {

                            smsRepository.save(sms).getValue() // 매칭된경우 저장한다.

                            smsRuleRepository.saveNotification(jsonObject)

                        }
                        Result.Success(jsonObject)
                    }
                } else { // 이미 존재함

                    Result.Success(null)
                }
            } else {

                Result.Success(null)
            }

        }  catch (e: Exception) {
            Result.Error(e)
        }
    }
}