package com.tenqube.visual_third.sms.data.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import com.tenqube.visual_third.sms.data.db.model.SmsRuleModel

@Dao
interface SmsRuleDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun save(sms: SmsRuleModel)

    @Query("SELECT * FROM smsrules")
    suspend fun findAll(): List<SmsRuleModel>


    @Query("SELECT * FROM smsrules WHERE sender = :sender")
    suspend fun findBySender(sender: String): List<SmsRuleModel>

}
