package com.tenqube.visual_third.sms.data.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import com.tenqube.visual_third.sms.data.db.model.SmsModel

@Dao
interface SmsDao {

    @Insert(onConflict = OnConflictStrategy.IGNORE)
    suspend fun save(sms: SmsModel)

    @Query("SELECT * FROM smses WHERE id = :id")
    suspend fun isExist(id: String): SmsModel?

    @Query("DELETE FROM smses")
    suspend fun deleteAll()

    @Query("DELETE FROM smses WHERE createdAt <= :date")
    suspend fun deleteByDate(date: Long)

}
