package com.tenqube.visual_third.sms.data.api

import com.tenqube.visual_third.sms.data.api.dto.NotificationDto
import com.tenqube.visual_third.sms.data.api.dto.SmsRuleDto
import retrofit2.Response
import retrofit2.http.*


interface NotiParserApi {
    companion object {
        const val DEV_URL = "https://o8mnfb36vj.execute-api.ap-northeast-2.amazonaws.com/dev/"
        const val PROD_URL = "https://o8mnfb36vj.execute-api.ap-northeast-2.amazonaws.com/prod/"

        const val SMS_RULE = "rules"
        const val NOTIFICATION = "notification"
        const val STATUS = "status"


    }

    @GET
    suspend fun getStatus(@Url url: String, @HeaderMap header: Map<String, String>)

    @GET
    suspend fun fetchSmsRules(@Url url: String, @HeaderMap header: Map<String, String>): SmsRulesDto

//    @POST("notification")
    @POST
    suspend fun saveNotification(@Url url: String, @HeaderMap header: Map<String, String>, @Body notification: NotificationDto)


}
