package com.tenqube.visual_third.parser.loader

import android.content.Context
import com.tenqube.visual_third.sms.domain.dto.SMSRequest
import com.tenqube.visual_third.sms.domain.dto.SMSResponse
import com.tenqube.visual_third.sms.presentation.SmsService
import com.tenqube.visual_third.sms.presentation.SmsServiceBuilder
import kotlinx.coroutines.runBlocking
import timber.log.Timber

object SmsManager {

    private var smsService: SmsService? = null

    fun parsing(context: Context, smsRequest: SMSRequest): SMSResponse? = runBlocking {

        return@runBlocking try {
            createSmsService(context)
            smsService?.parse(smsRequest).also {
                Timber.i("$it")
            }
        } catch (e: Exception) {
            null
        }
    }

    private fun createSmsService(context: Context) {
        if(smsService == null) {
            smsService = SmsServiceBuilder()
                    .with(context)
                    .build()
        }
    }
}