/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import androidx.fragment.app.FragmentActivity;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.ActivityCallback;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.util.WebViewHelper;
import com.tenqube.visual_third.web.ActionImpl;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.VisualInterface;

public class WebViewManager
implements ActivityCallback {
    private Context mContext;
    public WebView webview;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private ActivityCallback activityCallback;
    private VisualApi api;
    private VisualRepository repository;
    private VisualInterface.Action actionInterface;
    private VisualAlarmManager alarmManager;
    private Callback<String> callback;
    public View adView;

    public void setActivityCallback(ActivityCallback activityCallback) {
        this.activityCallback = activityCallback;
    }

    public WebViewManager(Context context, VisualRepository repository, VisualApi api, VisualAlarmManager alarmManager) {
        this.mContext = context;
        this.repository = repository;
        this.api = api;
        this.alarmManager = alarmManager;
    }

    public void setupWebView(WebView webview, final Callback<String> callback) {
        this.callback = callback;
        webview.setBackgroundColor(0);
        webview.setLayerType(1, null);
        webview.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.errorInterface = new ErrorImpl(this, webview);
        this.logInterface = new LogImpl(this, webview, this.errorInterface);
        this.repoInterface = new RepoImpl(this, webview, this.errorInterface, this.repository, this.api, new AnalysisServiceImpl(this.mContext, ""), this.alarmManager);
        this.uiInterface = new UiImpl(this, webview, this.errorInterface, new BottomDialog(this.mContext), AdManager.getInstance(this.mContext));
        this.systemInterface = new SystemImpl(this, webview, this.errorInterface, this.repository);
        this.actionInterface = new ActionImpl(this, webview);
        webview.addJavascriptInterface((Object)this.errorInterface, "visualError");
        webview.addJavascriptInterface((Object)this.repoInterface, "visualRepo");
        webview.addJavascriptInterface((Object)this.uiInterface, "visualUI");
        webview.addJavascriptInterface((Object)this.systemInterface, "visualSystem");
        webview.addJavascriptInterface((Object)this.logInterface, "visualLog");
        webview.addJavascriptInterface((Object)this.actionInterface, "visualAction");
        WebViewHelper.settings(webview);
        webview.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                callback.onDataLoaded(null);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                callback.onDataLoaded(failingUrl);
            }
        });
    }

    @Override
    public void exportExcel(Callback<Boolean> callback) {
        if (this.activityCallback != null) {
            this.activityCallback.exportExcel(callback);
        }
    }

    @Override
    public Context getContext() {
        if (this.activityCallback != null) {
            return this.activityCallback.getContext();
        }
        return this.mContext;
    }

    @Override
    public FragmentActivity getActivity() {
        if (this.activityCallback != null) {
            return this.activityCallback.getActivity();
        }
        return null;
    }

    @Override
    public void onPagedLoaded() {
        if (this.activityCallback != null) {
            this.activityCallback.onPagedLoaded();
        }
    }

    @Override
    public void onScrollChanged(int pos) {
        if (this.activityCallback != null) {
            this.activityCallback.onScrollChanged(pos);
        }
    }

    @Override
    public void reload() {
        if (this.activityCallback != null) {
            this.activityCallback.reload();
        }
    }

    @Override
    public void retry() {
        if (this.activityCallback != null) {
            this.activityCallback.retry();
        }
    }

    @Override
    public void setRefreshEnabled(boolean enabled) {
        if (this.activityCallback != null) {
            this.activityCallback.setRefreshEnabled(enabled);
        }
    }

    @Override
    public void addAd(View view) {
        this.adView = view;
        if (this.activityCallback != null) {
            this.activityCallback.addAd(view);
            this.adView = null;
        }
    }

    @Override
    public void hideAd() {
        if (this.activityCallback != null) {
            this.activityCallback.hideAd();
        }
    }

    @Override
    public TransactionPopupInfo getPopUpInfo() {
        if (this.activityCallback != null) {
            return this.activityCallback.getPopUpInfo();
        }
        return null;
    }

    @Override
    public void setStatusBarColor(String color2) {
        if (this.activityCallback != null) {
            this.activityCallback.setStatusBarColor(color2);
        }
    }

    public void onBackPressed() {
        if (this.uiInterface != null) {
            this.uiInterface.onFinish();
        }
    }

    public void onCalendar(String date, String callback) {
        if (this.uiInterface != null) {
            this.uiInterface.onCalendar(date, callback);
        }
    }

    public void onNotiCallback(String json) {
        if (this.systemInterface != null) {
            this.systemInterface.onNotiCallback(json);
        }
    }
}

