package com.tenqube.visual_third.model.api;

import com.google.gson.annotations.SerializedName;
import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.isStr;

public class SignUpRequest implements Serializable {

    @SerializedName("ktCustId")
    private final String custId;

    @SerializedName("adId")
    private String adId;

    public SignUpRequest(String custId) throws ParameterException {
        isStr(custId, 500);
        this.custId = custId;
    }

    public String getCustId() {
        return custId;
    }


    public void setAdId(String adId) {
        this.adId = adId;
    }
}
