package com.tenqube.visual_third.ui;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.fragment.app.DialogFragment;

import com.tenqube.visual_third.R;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.PrefManager;

public class ProgressDialogFragment extends DialogFragment {

    public static final String TAG = ProgressDialogFragment.class.getSimpleName();
    private Context context;

    private ProgressBar progressBar;
    private TextView percentTextView;

    public ProgressDialogFragment() {
        super();
    }

    public static ProgressDialogFragment newInstance(Context context) throws AuthException{
        if(TextUtils.isEmpty(PrefManager.getInstance(context).loadStringValue(PrefManager.UID, "")))
            throw new AuthException("Need to sign up");

        return new ProgressDialogFragment();
    }

    public void setProgressValue(int now, int total, int progress) {
        progressBar.setProgress(progress);
        percentTextView.setText(progress + "%");
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {

        try {
            if (context == null)
                context = getActivity();

            android.app.AlertDialog.Builder builder = new android.app.AlertDialog.Builder(context);
            View view = getActivity().getLayoutInflater().inflate(R.layout.dialog_progress,null);

            progressBar = (ProgressBar) view.findViewById(R.id.progress);
            percentTextView = (TextView) view.findViewById(R.id.percent);

            builder.setView(view);
            Dialog dialog = builder.create();
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
//        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCanceledOnTouchOutside(true);
            if(dialog.getWindow() != null) dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);
            return dialog;
        } catch (Exception e) {
            e.printStackTrace();
            dismissAllowingStateLoss();
        }
        return null;
    }

    @Override
    public void onStart() {
        super.onStart();
        Dialog dialog = getDialog();
        if (dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        }
    }
}
