package com.tenqube.visual_third.ui;

import android.content.Context;
import android.view.View;

import androidx.fragment.app.FragmentActivity;

import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;

public interface ActivityCallback {

    void exportExcel(Callback<Boolean> callback);

    Context getContext();

    FragmentActivity getActivity();

    void onPagedLoaded();

    void onScrollChanged(int pos);

    void reload();

    void retry();

    void setRefreshEnabled(boolean enabled);

    void addAd(View view);

    void hideAd();

    TransactionPopupInfo getPopUpInfo();

    void setStatusBarColor(String color);
}
