package com.tenqube.visual_third.manager;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;

import androidx.fragment.app.FragmentActivity;

import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.ActivityCallback;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.web.ActionImpl;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.VisualInterface;

import static com.tenqube.visual_third.util.WebViewHelper.settings;

public class WebViewManager implements ActivityCallback {

    private Context mContext;
    public WebView webview;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;

    private ActivityCallback activityCallback;


    private VisualApi api;
    private VisualRepository repository;

    private VisualInterface.Action actionInterface;
    private VisualAlarmManager alarmManager;

    private Callback<String> callback;
    public View adView;



    public void setActivityCallback(ActivityCallback activityCallback) {
        this.activityCallback = activityCallback;
    }

    public WebViewManager(Context context,
                           VisualRepository repository,
                           VisualApi api,
                           VisualAlarmManager alarmManager) {
        this.mContext = context;
        this.repository = repository;
        this.api = api;
        this.alarmManager = alarmManager;
    }

    public void setupWebView(WebView webview, final Callback<String> callback) {

        this.callback = callback;
        webview.setBackgroundColor(Color.TRANSPARENT);
        webview.setLayerType(WebView.LAYER_TYPE_SOFTWARE, null);
        webview.setLayoutParams(new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

        // javascriptInterface
        errorInterface = new ErrorImpl(this, webview);
        logInterface = new LogImpl(this, webview, errorInterface);

        repoInterface = new RepoImpl(this,
                webview,
                errorInterface,
                repository,
                api, new AnalysisServiceImpl(mContext, ""), alarmManager);
        uiInterface = new UiImpl(this, webview, errorInterface,
                new BottomDialog(mContext),
                AdManager.getInstance(mContext));
        systemInterface = new SystemImpl(this, webview, errorInterface, repository);

        actionInterface = new ActionImpl(this, webview);

        webview.addJavascriptInterface(errorInterface, "visualError");
        webview.addJavascriptInterface(repoInterface, "visualRepo");
        webview.addJavascriptInterface(uiInterface, "visualUI");
        webview.addJavascriptInterface(systemInterface, "visualSystem");
        webview.addJavascriptInterface(logInterface, "visualLog");
        webview.addJavascriptInterface(actionInterface, "visualAction");

        // settings
        settings(webview);

        webview.setWebViewClient(new WebViewClient() {

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                callback.onDataLoaded(null);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                callback.onDataLoaded(failingUrl);

            }
        });

    }

    @Override
    public void exportExcel(Callback<Boolean> callback) {
        if(activityCallback != null) {
            activityCallback.exportExcel(callback);
        }
    }

    @Override
    public Context getContext() {
        if(activityCallback != null) {
            return activityCallback.getContext();
        } else {
            return mContext;
        }
    }

    @Override
    public FragmentActivity getActivity() {
        if(activityCallback != null) {
            return activityCallback.getActivity();
        } else {
            return null;
        }
    }

    @Override
    public void onPagedLoaded() {

        if(activityCallback != null) {
            activityCallback.onPagedLoaded();
        }
    }

    @Override
    public void onScrollChanged(int pos) {
        if(activityCallback != null) {
            activityCallback.onScrollChanged(pos);
        }
    }

    @Override
    public void reload() {
        if(activityCallback != null) {
            activityCallback.reload();
        }
    }

    @Override
    public void retry() {
        if(activityCallback != null) {
            activityCallback.retry();
        }
    }

    @Override
    public void setRefreshEnabled(boolean enabled) {
        if(activityCallback != null) {
            activityCallback.setRefreshEnabled(enabled);
        }
    }

    @Override
    public void addAd(View view) {
        adView = view;

        if(activityCallback != null) {
            activityCallback.addAd(view);
            adView = null;
        }
    }

    @Override
    public void hideAd() {
        if(activityCallback != null) {
            activityCallback.hideAd();
        }
    }

    @Override
    public TransactionPopupInfo getPopUpInfo() {

        if(activityCallback != null) {
            return activityCallback.getPopUpInfo();
        }
        return null;
    }

    @Override
    public void setStatusBarColor(String color) {
        if(activityCallback != null) {
            activityCallback.setStatusBarColor(color);
        }
    }

    public void onBackPressed() {
        if(uiInterface != null) {
            uiInterface.onFinish();
        }
    }

    public void onCalendar(String date, String callback) {
        if(uiInterface != null) {
            uiInterface.onCalendar(date, callback);
        }
    }

    public void onNotiCallback(String json) {
        if(systemInterface != null) systemInterface.onNotiCallback(json);

    }
}
