package com.tenqube.visual_third.ui;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.widget.DatePicker;

import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;

import com.tenqube.visual_third.R;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.util.Utils;

import java.util.Calendar;

public class DatePickerFragment extends DialogFragment implements DatePickerDialog.OnDateSetListener {
    private static final String ARG_CAL = "request";

    private Callback mListener;
    private Calendar calendar;
    private DateRequest dateRequest;

    public static DatePickerFragment newInstance(DateRequest dateRequest) {
        DatePickerFragment fragment = new DatePickerFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARG_CAL, dateRequest);
        fragment.setArguments(args);
        return fragment;
    }

    public DatePickerFragment() {
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            dateRequest = (DateRequest) getArguments().getSerializable(ARG_CAL);
            if(dateRequest != null)
                calendar = Utils.toCalendarYMD(dateRequest.getDate());
        }
    }

    @NonNull
    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState){
        //Use the current date as the default date in the date picker
        int year = calendar.get(Calendar.YEAR);
        int month = calendar.get(Calendar.MONTH);
        int day = calendar.get(Calendar.DAY_OF_MONTH);

        DatePickerDialog dialog = new DatePickerDialog(getActivity(), R.style.PickerTheme,this, year, month, day);
        DatePicker datePicker = dialog.getDatePicker();

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, 2018);
        calendar.set(Calendar.MONTH, 0);
        calendar.set(Calendar.DATE, 1);

        datePicker.setMinDate(calendar.getTimeInMillis());

        calendar.set(Calendar.YEAR, (year+10));
        datePicker.setMaxDate(calendar.getTimeInMillis());

        return dialog;

    }

    public void onDateSet(DatePicker view, int year, int month, int day) {
        calendar.set(year,month,day);
        onCalendar(Utils.getYMD(calendar), dateRequest.getCallbackJS());
    }


    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof Callback) {
            mListener = (Callback) context;
        } else {
            throw new RuntimeException(context.toString()
                    + " must implement OnFragmentInteractionListener");
        }
    }

    public void onCalendar(String date, String callback) {
        if (mListener != null) {
            mListener.onCalendar(date, callback);
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        mListener = null;
    }

    public interface Callback {
        void onCalendar(String date, String callback);
    }
}
