/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.analysis;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.SparseArray;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.tenqube.visual_third.analysis.AnalysisHelper;
import com.tenqube.visual_third.analysis.AnalysisService;
import com.tenqube.visual_third.analysis.FunctionMap;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.JoinedContent;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.repository.AnalysisRepository;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;

public class AnalysisServiceImpl
implements AnalysisService {
    public static final String ACTION_REFRESHED = "tenqube.intent.action.ACTION_REFRESHED";
    private final Context context;
    private final AnalysisRepository repository;
    private ArrayList<Analysis> results = new ArrayList();
    private long time;
    private boolean isReceived;
    private String layer;
    private LocalBroadCastReceiver receiver = new LocalBroadCastReceiver();

    public AnalysisServiceImpl(Context context, String layer) {
        this.context = context;
        this.repository = AnalysisRepository.getInstance(context);
        this.layer = layer;
        IntentFilter filter = new IntentFilter();
        filter.addAction("tenqube.intent.action.ACTION_TRANSACTION_RECEIVED");
        filter.addAction(ACTION_REFRESHED);
        LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)this.receiver, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Analysis> loadAnalysisList(ArrayList<Transaction> transactions) {
        FunctionMap functionMap = null;
        try {
            this.initCache();
            if (!Utils.isEmpty(this.results)) {
                ArrayList<Analysis> arrayList = this.results;
                return arrayList;
            }
            this.time = System.currentTimeMillis();
            functionMap = new FunctionMap();
            functionMap.calculate(transactions);
            ArrayList<JoinedContent> allContents = this.repository.loadContents();
            ArrayList<JoinedContent> categoryContents = new ArrayList<JoinedContent>();
            Iterator<JoinedContent> it = allContents.iterator();
            while (it.hasNext()) {
                JoinedContent joinedContent = it.next();
                if (joinedContent.getContent().getlCode() != 0) continue;
                categoryContents.add(joinedContent);
                it.remove();
            }
            allContents = this.getSatisfiedContents(allContents);
            SparseArray<ArrayList<Analysis>> analysisByCategory = this.mergeContentsByCategory(allContents);
            analysisByCategory = functionMap.loadCommonCategory(analysisByCategory, categoryContents);
            this.results = this.selectAnalysis(analysisByCategory);
            AnalysisHelper.descAnalysis(this.results);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FunctionMap.values.clear();
            FunctionMap.tranIds.clear();
            functionMap = null;
        }
        return this.results;
    }

    private ArrayList<Analysis> selectAnalysis(SparseArray<ArrayList<Analysis>> analysisByCategory) {
        ArrayList<Analysis> selectedAnalysis = new ArrayList<Analysis>();
        ArrayList monthly = (ArrayList)analysisByCategory.get(11);
        analysisByCategory.remove(11);
        if (!Utils.isEmpty(monthly)) {
            selectedAnalysis.add((Analysis)monthly.get(Utils.getRandomNumber(monthly.size())));
        }
        ArrayList weekly = (ArrayList)analysisByCategory.get(2);
        analysisByCategory.remove(2);
        if (!Utils.isEmpty(weekly)) {
            selectedAnalysis.add((Analysis)weekly.get(Utils.getRandomNumber(weekly.size())));
        }
        for (int i = 0; i < analysisByCategory.size(); ++i) {
            int lcode = analysisByCategory.keyAt(i);
            ArrayList categoryAnalysis = (ArrayList)analysisByCategory.get(lcode);
            if (Utils.isEmpty(categoryAnalysis)) continue;
            selectedAnalysis.add((Analysis)categoryAnalysis.get(Utils.getRandomNumber(categoryAnalysis.size())));
        }
        analysisByCategory.clear();
        return selectedAnalysis;
    }

    private void initCache() {
        if (this.isReceived || this.isTimeOver()) {
            this.isReceived = false;
            this.time = 0L;
            this.results.clear();
        }
    }

    private boolean isTimeOver() {
        return (System.currentTimeMillis() - this.time) / 1000L > 60L;
    }

    private ArrayList<JoinedContent> getSatisfiedContents(ArrayList<JoinedContent> contents) {
        ArrayList<JoinedContent> results = new ArrayList<JoinedContent>();
        for (JoinedContent content : contents) {
            boolean isSatisfied = true;
            ArrayList<Condition> conditions = content.getConditions();
            if (!Utils.isEmpty(conditions)) {
                Condition condition;
                Iterator<Condition> iterator = conditions.iterator();
                while (iterator.hasNext() && (isSatisfied = AnalysisHelper.isSatisfied(condition = iterator.next()))) {
                }
            }
            if (!isSatisfied) continue;
            results.add(content);
        }
        return results;
    }

    private SparseArray<ArrayList<Analysis>> mergeContentsByCategory(ArrayList<JoinedContent> contents) {
        SparseArray analysisMap = new SparseArray();
        for (JoinedContent content : contents) {
            try {
                String image = AnalysisHelper.getValue(content.getContent().getImage());
                String label = AnalysisHelper.getValue(content.getContent().getLabel());
                String lContent = AnalysisHelper.getContent(content.getContent().getlContent(), content.getContent().getlKeys());
                String mContent = AnalysisHelper.getContent(content.getContent().getmContent(), content.getContent().getmKeys());
                Analysis analysis = new Analysis(content.getContent().getId(), image, label, lContent, mContent, this.mergeTranIds(content.getContent().getRawKeys()), content.getContent().getCategoryPriority());
                ArrayList<Analysis> analyses = (ArrayList<Analysis>)analysisMap.get(content.getContent().getlCode());
                if (analyses == null) {
                    analyses = new ArrayList<Analysis>();
                }
                analyses.add(analysis);
                analysisMap.put(content.getContent().getlCode(), analyses);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return analysisMap;
    }

    private ArrayList<Integer> mergeTranIds(String rawKeys) {
        String[] keys;
        ArrayList<Integer> tranIds = new ArrayList<Integer>();
        for (String key : keys = rawKeys.split(",")) {
            ArrayList tempTranIds = (ArrayList)FunctionMap.tranIds.get(Integer.parseInt(key));
            if (tempTranIds == null) continue;
            tranIds.addAll(tempTranIds);
        }
        return tranIds;
    }

    public class LocalBroadCastReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            AnalysisServiceImpl.this.isReceived = true;
        }
    }
}

