package com.tenqube.visual_third.model.api;


import com.google.gson.annotations.SerializedName;

import java.io.Serializable;
import java.util.ArrayList;

public class SearchCompanyResponse implements Serializable {

    private ArrayList<TranCompany> results;

    public SearchCompanyResponse(ArrayList<TranCompany> results) {
        this.results = results;
    }

    public ArrayList<TranCompany> getResults() {
        return results;
    }

    public static class TranCompany implements Serializable {

        @SerializedName("id")
        private String identifier;

        @SerializedName("classCode")
        private String classCode;

        @SerializedName("company")
        private Company company;

        @SerializedName("category")
        private Category category;

        @SerializedName("keyword")
        private Keyword keyword;

        private boolean isPopUpCompanyName;

        public TranCompany(String identifier, String classCode, Company company, Category category, Keyword keyword) {
            this.identifier = identifier;
            this.classCode = classCode;
            this.company = company;
            this.category = category;
            this.keyword = keyword;
        }

        public String getIdentifier() {
            return identifier;
        }

        public String getClassCode() {
            return classCode;
        }

        public Company getCompany() {
            return company;
        }

        public Category getCategory() {
            return category;
        }

        public Keyword getKeyword() {
            return keyword;
        }

        public boolean isPopUpCompanyName() {
            return isPopUpCompanyName;
        }
    }

    public static class Company implements Serializable {
        private int id;
        private String name;
        private String address;

        public Company(int id, String name, String address) {
            this.id = id;
            this.name = name;
            this.address = address;
        }

        public int getId() {
            return id;
        }

        public String getName() {
            return name;
        }

        public String getAddress() {
            return address;
        }
    }

    public static class Category implements Serializable {

        public Category(String code) {
            this.code = code;
        }

        private String code;

        public String getCode() {
            return code;
        }

        public String getRepCode() {
            return code.substring(0, 2) + "1010";
        }

        public String getLargeCode() {
            return code.substring(0, 2) + "";
        }


    }

    public static class Keyword implements Serializable {
        private String ori;
        private String search;

        public Keyword(String ori, String search) {
            this.ori = ori;
            this.search = search;
        }

        public String getOri() {
            return ori;
        }

        public String getSearch() {
            return search;
        }
    }
}
