package com.tenqube.visual_third.model.api;


import android.text.TextUtils;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;
import java.util.ArrayList;

import tenqube.parser.constants.Constants;

public class SearchCompanyRequest implements Serializable {

    private ArrayList<Transaction> transactions;

    public ArrayList<Transaction> getTransactions() {
        return transactions;
    }

    public SearchCompanyRequest(ArrayList<Transaction> transactions) {
        this.transactions = transactions;
    }

    public static class Transaction  {
        @SerializedName("id")
        String identifier;

        @SerializedName("keyword")
        String keyword;

        @Expose
        String type;

        @Expose
        String at;

        @Expose
        String method;

        @Expose
        double amount;

        @Expose
        String amountType;

        @Expose
        double lat;

        @SerializedName("long")
        double lng;

        @Expose
        private Integer lCode;

        @Expose
        private Integer mCode;


        public String getIdentifier() {
            return identifier;
        }

        public Transaction(tenqube.parser.model.Transaction transaction) throws ParameterException {
            if(transaction == null || TextUtils.isEmpty(transaction.spentDate))
                throw new ParameterException(transaction == null ? "transaction is null" : "spentDate" + transaction.spentDate);

            this.identifier = transaction.identifier;
            this.keyword = transaction.keyword;
            this.type = transaction.dwType == Constants.DWType.DEPOSIT.ordinal() ? "deposit" : "withdraw";

            this.at = transaction.spentDate;

            this.method = transaction.cardType == 0 ? "debit" : transaction.cardType == 1 ? "credit" : "account";
            this.amount = transaction.spentMoney;
            this.amountType = TextUtils.isEmpty(transaction.currency) ? "KRW" : transaction.currency;
            this.lat = transaction.spentLatitude;
            this.lng = transaction.spentLongitude;
        }

        public Transaction(JoinedTransaction transaction) throws ParameterException {
            if(transaction == null || transaction.getTransaction() == null ||
                    TextUtils.isEmpty(transaction.getTransaction().getSpentDate()))
                throw new ParameterException("check transaction");

            this.identifier = transaction.getTransaction().getIdentifier() + "";
            this.keyword = transaction.getTransaction().getKeyword();
            this.type = transaction.getTransaction().getDwType() == Constants.DWType.DEPOSIT.ordinal() ? "deposit" : "withdraw";

            this.at = transaction.getTransaction().getSpentDate();

            this.method = transaction.getCard().getType() == 0 ? "debit" : transaction.getCard().getType() == 1 ? "credit" : "account";
            this.amount = transaction.getTransaction().getSpentMoney();
            this.amountType = TextUtils.isEmpty(transaction.getTransaction().getCurrency()) ? "KRW" : transaction.getTransaction().getCurrency();
            this.lat = transaction.getTransaction().getLat();
            this.lng = transaction.getTransaction().getLng();
        }
    }
}
