package com.tenqube.visual_third.util;

import android.os.Environment;

import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.repository.VisualRepository;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CSVHelper {

    private final VisualRepository repository;

    private static final char DEFAULT_SEPARATOR = ',';

    private AppExecutors appExecutors;
    public CSVHelper(VisualRepository repository) {
        this.repository = repository;
        this.appExecutors = new AppExecutors();
    }

    private void writeLine(Writer w, List<String> values) throws IOException {
        writeLine(w, values, DEFAULT_SEPARATOR, ' ');
    }

    private void writeLine(Writer w, List<String> values, char separators) throws IOException {
        writeLine(w, values, separators, ' ');
    }

    //https://tools.ietf.org/html/rfc4180
    private String followCVSformat(String value) {

        String result = value;
        if (result.contains("\"")) {
            result = result.replace("\"", "\"\"");
        }
        return result;

    }

    private void writeLine(Writer w, List<String> values, char separators, char customQuote) throws IOException {

        boolean first = true;

        if (separators == ' ') {
            separators = DEFAULT_SEPARATOR;
        }

        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            value = value.replace(",", " ").replace("\n", " ");

            if (!first) {
                sb.append(separators);
            }
            if (customQuote == ' ') {
                sb.append(followCVSformat(value));
            } else {
                sb.append(customQuote).append(followCVSformat(value)).append(customQuote);
            }

            first = false;
        }
        sb.append("\n");
        w.append(sb.toString());


    }

    public static final String HEADERS =
            "id," +
            "identifier," +
            "cardId," +
            "userCategoryId," +
            "companyId," +
            "franchise," +
            "code," +
            "spentDate," +
            "lat," +
            "lng," +
            "spentMoney," +
            "oriSpentMoney," +
            "installmentCnt," +
            "keyword," +
            "repeatType," +
            "currency," +
            "dwType," +
            "fullSms," +
            "smsDate," +
            "smsType," +
            "regId," +
            "isOffset," +
            "isCustom," +
            "isUserUpdate," +
            "isUpdateAll," +
            "memo," +
            "classCode," +
            "isSynced," +
            "cardName," +
            "cardType," +
            "cardSubType," +
            "cardChangeName," +
            "cardChangeType," +
            "cardChangeSubType," +
            "billingDay," +
            "balance," +
            "cardMemo," +
            "cardIsExcept," +
            "cateIsExcept," +
            "large," +
            "medium," +
            "small";

    public void export(final Callback completion) {

        appExecutors.diskIO().execute(new Runnable() {
            @Override
            public void run() {

                try {
                    final String csvFile = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS) + "/Visual.csv";
                    final File file = new File(csvFile);
                    file.createNewFile();
                    FileWriter writer = new FileWriter(file);

                    writeLine(writer, Arrays.asList(HEADERS.split(",")));


                    ArrayList<JoinedTransaction> transactions = repository.loadJoinedTransactions();

                    for(JoinedTransaction tran : transactions) {
                        List<String> values = new ArrayList<>();
                        values.add(tran.getTransaction().getId() + "");
                        values.add(tran.getTransaction().getIdentifier() + "");
                        values.add(tran.getTransaction().getCardId() + "");
                        values.add(tran.getTransaction().getUserCategoryId() + "");
                        values.add(tran.getTransaction().getCompanyId() + "");
                        values.add(tran.getTransaction().getFranchise() + "");
                        values.add(tran.getTransaction().getCategoryCode() + "");
                        values.add(tran.getTransaction().getSpentDate() + "");
                        values.add(tran.getTransaction().getLat() + "");
                        values.add(tran.getTransaction().getLng() + "");
                        values.add(tran.getTransaction().getSpentMoney() + "");
                        values.add(tran.getTransaction().getOriSpentMoney() + "");
                        values.add(tran.getTransaction().getInstallmentCnt() + "");
                        values.add(tran.getTransaction().getKeyword() + "");
                        values.add(tran.getTransaction().getRepeatType() + "");
                        values.add(tran.getTransaction().getCurrency() + "");
                        values.add(tran.getTransaction().getDwType() + "");
                        values.add(tran.getTransaction().getFullSms().replace("\n", "") + "");
                        values.add(tran.getTransaction().getSmsDate() + "");
                        values.add(tran.getTransaction().getSmsType() + "");
                        values.add(tran.getTransaction().getRegId() + "");
                        values.add(tran.getTransaction().isOffset() + "");
                        values.add(tran.getTransaction().isCustom() + "");
                        values.add(tran.getTransaction().isUserUpdate() + "");
                        values.add(tran.getTransaction().isUpdateAll() + "");
                        values.add(tran.getTransaction().getMemo() + "");
                        values.add(tran.getTransaction().getClassCode() + "");
                        values.add(tran.getTransaction().isSynced() + "");
                        values.add(tran.getCard().getName() + "");
                        values.add(tran.getCard().getType() + "");
                        values.add(tran.getCard().getSubType() + "");
                        values.add(tran.getCard().getChangeName() + "");
                        values.add(tran.getCard().getChangeType() + "");
                        values.add(tran.getCard().getChangeSubType() + "");
                        values.add(tran.getCard().getBillingDay() + "");
                        values.add(tran.getCard().getBalance() + "");
                        values.add(tran.getCard().getMemo() + "");
                        values.add(tran.getCard().isExcept() + "");
                        values.add(tran.getUserCategory().isExcept() + "");
                        values.add(tran.getCategory().getLarge() + "");
                        values.add(tran.getCategory().getMedium() + "");
                        values.add(tran.getCategory().getSmall() + "");

                        writeLine(writer, values);
                    }

                    writer.flush();
                    writer.close();

                    appExecutors.mainThread().execute(new Runnable() {
                        @Override
                        public void run() {
                        completion.onCompleted(file);
                        }
                    });
                } catch (IOException e) {

                    e.printStackTrace();
                }

            }
        });


    }

    public interface Callback {
        void onCompleted(File file);
    }

}