package com.tenqube.visual_third.web;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v4.app.FragmentManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.NotiCatchDialogFragment;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Utils;

import static com.tenqube.visual_third.ui.VisualWebActivity.NOTIFICATION_REQUEST_CODE;
import static com.tenqube.visual_third.util.Validator.isStr;

public class SystemImpl extends Base implements VisualInterface.System  {

    private String callbackNoti;
    private VisualRepository repository;


    public SystemImpl(VisualWebActivity activity, WebView webView, VisualInterface.Error error, VisualRepository repository) {
        super(activity, webView, error);
        this.repository = repository;
    }

    public void onNotiCallback(final String json) {
        callbackWithStr(callbackNoti, json);
    }

    @JavascriptInterface
    public String getAppVersion() {
        return repository.getAppVersion();
    }

    @JavascriptInterface
    public void startNotiListener(final String callback) {

        String funcName = "startNotiListener";
        try {

            isStr(callback, 100);
            // params 파싱해서 callback 구하기
            this.callbackNoti = callback;

            if(isNotiEnabled()) {
                goNotiSettings(callbackNoti);
            } else {
                NotiCatchDialogFragment notiCatchDialogFragment = NotiCatchDialogFragment.newInstance();

                notiCatchDialogFragment.setCallback(new NotiCatchDialogFragment.Callback() {
                    @Override
                    public void onClickNext() {
                        goNotiSettings(callbackNoti);
                    }
                });

                if(!notiCatchDialogFragment.isAdded()) {
                    FragmentManager fragmentManager = activity.getSupportFragmentManager();
                    if(fragmentManager != null) {
                        fragmentManager.beginTransaction().add(notiCatchDialogFragment, NotiCatchDialogFragment.TAG).commitAllowingStateLoss();
                    }
                }
            }

        } catch (ParameterException e) {
            onError(funcName, e.toString());
        } catch (Exception e) {
            e.printStackTrace();
            onError(funcName, e.toString());
        }
    }

    @JavascriptInterface
    public void goNotiSettings(final String callback) {

        String funcName = "goNotiSettings";
        try {

            isStr(callback, 100);
            // params 파싱해서 callback 구하기
            this.callbackNoti = callback;

            try {
                Intent intent = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
                activity.startActivityForResult(intent, NOTIFICATION_REQUEST_CODE);

            } catch (ActivityNotFoundException e){
                e.printStackTrace();
                onError(funcName, e.toString());
            }

        } catch (ParameterException e) {
            onError(funcName, e.toString());
        } catch (Exception e) {
            e.printStackTrace();
            onError(funcName, e.toString());
        }
    }

    @JavascriptInterface
    public boolean isNotiEnabled() {

        String funcName = "isNotiEnabled";
        try {
            return Utils.isNotiEnabled(activity.getApplicationContext());
        } catch (Exception e) {
            e.printStackTrace();
            onError(funcName, e.toString());
        }
        return false;
    }

    /**
     * 네트워크 연결 여부
     */
    @JavascriptInterface
    public boolean isNetworkConnected() {

        String funcName = "isNetworkConnected";

        try {
            ConnectivityManager cm =
                    (ConnectivityManager)activity.getSystemService(Context.CONNECTIVITY_SERVICE);

            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null &&
                    activeNetwork.isConnectedOrConnecting();

            return isConnected;
        } catch (Exception e) {
            e.printStackTrace();
            onError(funcName, e.toString());
        }
        return true;

    }

}
