/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.util;

import android.text.TextUtils;
import com.google.gson.Gson;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Locale;

public class Utils {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private static final DecimalFormat THREE_COMMA_FORMAT = new DecimalFormat("###,###");

    public static <T> T fromJson(String param, Class<T> classOfT) {
        Gson gson = new Gson();
        return (T)gson.fromJson(param, classOfT);
    }

    public static String toJson(Object object) {
        Gson gson = new Gson();
        return gson.toJson(object);
    }

    public static boolean shouldParsing(String msg) {
        int cnt = 0;
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return false;
        }
        if (msg.contains("\uc6d0")) {
            ++cnt;
        }
        if (msg.contains(".")) {
            ++cnt;
        }
        if (msg.contains(",")) {
            ++cnt;
        }
        if (cnt == 3) {
            return true;
        }
        if (msg.contains("/")) {
            ++cnt;
        }
        return cnt > 2;
    }

    public static String getConvertedDate(long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        return Utils.getStringDateAsYYYYMMddHHmmss(cal);
    }

    public static String getStringDateAsYYYYMMddHHmmss(Calendar cal) {
        try {
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            return cal.get(1) + "-" + DECIMAL_FORMAT.format(cal.get(2) + 1) + "-" + DECIMAL_FORMAT.format(cal.get(5)) + " " + DECIMAL_FORMAT.format(cal.get(11)) + ":" + DECIMAL_FORMAT.format(cal.get(12)) + ":" + DECIMAL_FORMAT.format(cal.get(13));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String threeComma(double value) {
        return THREE_COMMA_FORMAT.format((long)value) + "\uc6d0";
    }

    public static String makeDialogPath(int tranId, String keyword, String lCategory, String mCategory, int lCode, int mCode, String spentDate, double amount, int installmentCnt, int cardId, String memo, String dwType, String prevPage) {
        return String.format(Locale.KOREA, "dialog/?id=%1$d&keyword=%2$s&lCategory=%3$s&mCategory=%4$s&lCode=%5$d&mCode=%6$d&date=%7$s&amount=%8$f&installmentCnt=%9$d&cardId=%10$d&memo=%11$s&dwType=%12$s&prevPage=%13$s", tranId, keyword, lCategory, mCategory, lCode, mCode, spentDate, amount, installmentCnt, cardId, memo, dwType, prevPage);
    }
}

