/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.design.widget.Snackbar;
import android.text.TextUtils;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Toast;
import com.tenqube.visual_third.core.BottomDialog;
import com.tenqube.visual_third.core.VisualWebActivity;
import com.tenqube.visual_third.model.js.Cards;
import com.tenqube.visual_third.model.js.CategoryInfo;
import com.tenqube.visual_third.model.js.Lv0Info;
import com.tenqube.visual_third.model.js.NewViewInfo;
import com.tenqube.visual_third.model.js.SelectBoxInfo;
import com.tenqube.visual_third.model.js.SelectBoxRequest;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.model.js.Transactions;
import com.tenqube.visual_third.model.js.UpdateTransactionRequest;
import com.tenqube.visual_third.util.GoOpenMarketUtil;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;

public class WebAppInterface
implements BottomDialog.OnBottomListener {
    private final Activity activity;
    private final WebView webView;
    private String callbackSelectOrderBy;
    private BottomDialog bottomDialog;

    public WebAppInterface(Activity activity, WebView webView, BottomDialog bottomDialog) {
        this.activity = activity;
        this.webView = webView;
        this.bottomDialog = bottomDialog;
        this.bottomDialog.setBottomListener(this);
    }

    @JavascriptInterface
    public void openSelectBox(String params) {
        try {
            SelectBoxRequest selectBoxRequest = Utils.fromJson(params, SelectBoxRequest.class);
            this.callbackSelectOrderBy = selectBoxRequest.getDataCallbackJS();
            if (this.bottomDialog != null) {
                this.bottomDialog.showBottomDialog(selectBoxRequest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onItemSelected(SelectBoxInfo selectBoxInfo) {
        this.bottomDialog.dismiss();
        this.callback(this.callbackSelectOrderBy, selectBoxInfo);
    }

    @JavascriptInterface
    public void openNewView(String params) {
        try {
            NewViewInfo newViewInfo = Utils.fromJson(params, NewViewInfo.class);
            if (newViewInfo == null) {
                return;
            }
            if ("external".equals(newViewInfo.getViewType())) {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(Uri.parse((String)newViewInfo.getUrl()));
                this.activity.startActivity(i);
            } else if ("internal".equals(newViewInfo.getViewType())) {
                VisualWebActivity.startActivity((Context)this.activity, newViewInfo.getUrl());
            } else if ("google".equals(newViewInfo.getViewType())) {
                GoOpenMarketUtil.openOnGooglePlayMarket((Context)this.activity, newViewInfo.getUrl());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void finish() {
        try {
            if (this.activity != null) {
                this.activity.finish();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void getCategories(String callback) {
        try {
            ArrayList<CategoryInfo.ServerCategory> serverCategories = new ArrayList<CategoryInfo.ServerCategory>();
            serverCategories.add(new CategoryInfo.ServerCategory(1, "\uc2dd\uc0ac", "\ud55c\uc2dd", 2210));
            serverCategories.add(new CategoryInfo.ServerCategory(2, "\uc0dd\ud65c/\ub9c8\ud2b8", "\ub300\ud615\ub9c8\ud2b8", 3410));
            ArrayList<CategoryInfo.UserCategory> userCategories = new ArrayList<CategoryInfo.UserCategory>();
            userCategories.add(new CategoryInfo.UserCategory(1, 2210, 0, 0));
            userCategories.add(new CategoryInfo.UserCategory(2, 3410, 0, 0));
            CategoryInfo categoryInfo = new CategoryInfo(serverCategories, userCategories);
            this.callback(callback, categoryInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void getCards(String callback) {
        try {
            ArrayList<Cards.Card> cardList = new ArrayList<Cards.Card>();
            cardList.add(new Cards.Card(1, "\uc2e0\ud55c", "\uc2e0\ud55c", 0, 0, "", "", 0.0, 0));
            Cards cards = new Cards(cardList);
            this.callback(callback, cards);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void getTransactions(String params) {
        try {
            TransactionRequest transactionRequest = Utils.fromJson(params, TransactionRequest.class);
            ArrayList<Transactions.Transaction> tranList = new ArrayList<Transactions.Transaction>();
            tranList.add(new Transactions.Transaction(1, 221010, "\uc2dd\uc0ac", "\ud55c\uc2dd", 1, 1, "", 1, "\uc2e0\ud55c", 2000.0, 1, 0, 0, 1, "", 0, "2018-07-12 22:22:22", "2018-07-12 22:22:22", "\uc2dd\ub2f9\ud0a4\uc6cc\ub4dc", "\uba54\ubaa8"));
            Transactions transactions = new Transactions(tranList);
            this.callback(transactionRequest.getCallbackJS(), transactions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void getLv0Contents(String callback) {
        try {
            ArrayList<Lv0Info.Lv0> lv0s = new ArrayList<Lv0Info.Lv0>();
            lv0s.add(new Lv0Info.Lv0("lv0_mid_beauty_nail", "\ubdf0\ud2f0/\ubbf8\uc6a9", "\ub124\uc77c \ucf00\uc5b4  \ubc1b\uc740 \uc9c0 15\uc77c \ub418\uc5c8\uc2b5\ub2c8\ub2e4.", "\ub9c8\uc9c0\ub9c9\uc73c\ub85c \ucf00\uc5b4 \ubc1b\uc740 \ub0a0\uc740\n%s (%s) \uc785\ub2c8\ub2e4.  \n\n\uc9c0\ub09c 3\uac1c\uc6d4\uac04 \ub124\uc77c\ucf00\uc5b4\ub97c \ucd1d %s\ubc88 \ubc1b\uc558\uc2b5\ub2c8\ub2e4."));
            lv0s.add(new Lv0Info.Lv0("lv0_mid_culture_movies", "\ubb38\ud654/\uc608\uc220", "\uc601\ud654 \ubcf8 \uc9c0 15\uc77c \uc9c0\ub0ac\uc2b5\ub2c8\ub2e4.", "\ub9c8\uc9c0\ub9c9\uc73c\ub85c \uc601\ud654 \ubcf8 \ub0a0\uc740\n%s (%s) \uc785\ub2c8\ub2e4.  \n\n\uc9c0\ub09c 3\uac1c\uc6d4, \uc601\ud654\ub97c %s\ubc88 \ubd24\uc2b5\ub2c8\ub2e4. "));
            Lv0Info lv0Info = new Lv0Info(lv0s);
            this.callback(callback, lv0Info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void updateTransaction(String params) {
        try {
            UpdateTransactionRequest updateTransactionRequest = Utils.fromJson(params, UpdateTransactionRequest.class);
            this.callback(updateTransactionRequest.getCallbackJS(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void callback(final String callback, final Object object) {
        try {
            this.webView.post(new Runnable(){

                @Override
                public void run() {
                    WebAppInterface.this.webView.loadUrl(WebAppInterface.this.getJs(callback, object == null ? "" : Utils.toJson(object)));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void showSnackBar(String msg) {
        try {
            Snackbar.make((View)this.webView, (CharSequence)msg, (int)-1).show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void showToast(String msg) {
        try {
            Toast.makeText((Context)this.activity, (CharSequence)msg, (int)0).show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getJs(String callback, String data) {
        if (!TextUtils.isEmpty((CharSequence)data)) {
            data = "'" + data + "'";
        }
        return "javascript:window." + callback + "(" + data + ");";
    }
}

